#define UCHAR	unsigned char
#define USHORT	unsigned short

#define PCHAR	unsigned char *

UCHAR mod_16x8(USHORT s16, UCHAR i8);

UCHAR state[256];
UCHAR x, y;

void swap(PCHAR pa, PCHAR pb)
{
	UCHAR iTemp;

	iTemp = *pa;
	*pa = *pb;
	*pb = iTemp;
}

void RC4Init(PCHAR pKey, UCHAR iKeyLen)
{
	UCHAR i;

	i = 0;
	do
	{
		state[i] = i;
		i ++;
	} while (i);

	x = 0;
	do
	{
		x = x + state[i] + pKey[mod_16x8(i, iKeyLen)];
//      this is correctly compiled
//		x += state[i] + pKey[mod_16x8(i, iKeyLen)]; 
		swap(&state[i], &state[x]);
		i ++;
	} while(i);
	x = 0;
	y = 0;
}

void RC4Calc(PCHAR pDst, PCHAR pSrc, USHORT sLen)
{
	USHORT k;
	UCHAR r;

	for (k = 0; k < sLen; k ++)
	{
		x ++;
		y += state[x];
		swap(&state[x], &state[y]);
		r = state[x] + state[y];
		*pDst++ = (*pSrc++) ^ state[r];
	}
}
