#include "version.h"
#include "type.h"
#include "ar168.h"
#include "core.h"
#include "apps.h"
#include "tcpip.h"
#include "bank3.h"

/*********************************************************************************
** A TCP client demo code
**********************************************************************************/

TCP_HANDLE _pDemoTcpServerTcb;

void DemoTcpServerRun(TCP_HANDLE h, USHORT sLen, PCHAR pBuf);

void DemoTcpServerInit()
{
	_pDemoTcpServerTcb = TcpListen(DEMO_TCP_SERVER_PORT, TCP_BANK_OFFSET, (USHORT)DemoTcpServerRun);
	_bNeedReboot = FALSE;
	_iRebootTimer = 0;
}

void DemoTcpServerRunData(USHORT sLen, PCHAR pBuf)
{
}

void DemoTcpServerRun(TCP_HANDLE h, USHORT sLen, PCHAR pBuf)
{
	UCHAR iEvent;

	if (_pDemoTcpServerTcb != h)
	{
		UdpDebugString("unkown Httpd handle");
		TcpFree(h);
		return;
	}

	iEvent = TcpGetEvent(h);
	if (iEvent & (TCP_EVENT_RESET|TCP_EVENT_ABORT|TCP_EVENT_USERTO|TCP_EVENT_RETRYTO))
	{
		UdpDebugString("Http reset/abort/timeout");
		if (iEvent & TCP_EVENT_ABORT)
		{
			TcpStartSend(h);
		}
		TcpFree(h);
		// TCP Connection is cleared, do something here
		return;
	}

	if (iEvent & TCP_EVENT_ACCEPT)
	{
		UdpDebugString("TCP accept");
		// Client is connecting to server, do something here
		return;
	}
	if (iEvent & TCP_EVENT_CONNECT)
	{
		// TCP connection is established
		UdpDebugString("TCP connect");
	}
	if (iEvent & TCP_EVENT_DATA)
	{
		// Incoming data from the TCP connection, handle these data here
		UdpDebugString("TCP data");
		DemoTcpServerRunData(sLen, pBuf);
	}
	if (iEvent & TCP_EVENT_CLOSE)
	{
		// Client want to close this connection
		UdpDebugString("Http close");
	}

	TcpClearEvent(h);
	// If you want to send data, call 
	//TcpWriteStr(_pDemoTcpServerTcb, pString);
	// or you can call
	//TcpWriteData(_pDemoTcpServerTcb, pData, sLen);
	// either way, the length of the data shouldn't exceed TCP_SND_MSS

	// If you want to close this connection, call
	//TcpClose(h);

	TcpStartSend(h);
}


/*********************************************************************************
** A TCP client demo code
**********************************************************************************/
TCP_HANDLE _pDemoTcpClientTcb;

void DemoTcpClientRun(TCP_HANDLE h, USHORT sLen, PCHAR pBuf);

void DemoTcpClientOpen(PCHAR pServerIP, USHORT sServerPort)
{
	_pDemoTcpClientTcb = TcpOpen(pServerIP, sServerPort, 0, TCP_BANK_OFFSET, (USHORT)DemoTcpClientRun);
}

void DemoTcpClientRunData(USHORT sLen, PCHAR pBuf)
{
}

void DemoTcpClientRun(TCP_HANDLE h, USHORT sLen, PCHAR pBuf)
{
	UCHAR iEvent;

	if (_pDemoTcpClientTcb != h)
	{
		UdpDebugString("unkown Httpd handle");
		TcpFree(h);
		return;
	}

	iEvent = TcpGetEvent(h);
	if (iEvent & (TCP_EVENT_RESET|TCP_EVENT_ABORT|TCP_EVENT_USERTO|TCP_EVENT_RETRYTO))
	{
		UdpDebugString("Http reset/abort/timeout");
		if (iEvent & TCP_EVENT_ABORT)
		{
			TcpStartSend(h);
		}
		TcpFree(h);
		// TCP Connection is cleared, do something here
		return;
	}

	if (iEvent & TCP_EVENT_CONNECT)
	{
		// TCP connection is established
		UdpDebugString("TCP connect");
	}
	if (iEvent & TCP_EVENT_DATA)
	{
		// Incoming data from the TCP connection, handle these data here
		UdpDebugString("TCP data");
		DemoTcpClinetRunData(sLen, pBuf);
	}
	if (iEvent & TCP_EVENT_CLOSE)
	{
		// Client want to close this connection
		UdpDebugString("Http close");
	}

	TcpClearEvent(h);
	// If you want to send data, call 
	//TcpWriteStr(_pDemoTcpClientTcb, pString);
	// or you can call
	//TcpWriteData(_pDemoTcpClientTcb, pData, sLen);
	// either way, the length of the data shouldn't exceed TCP_SND_MSS

	// If you want to close this connection, call
	//TcpClose(h);

	TcpStartSend(h);
}
