/*-------------------------------------------------------------------------
   AR1688 SLIC function copy right information

   Copyright (C) 2007-2010. Lin, Rongrong <woody@palmmicro.com>
						    Li, Jing      <lijing@palmmicro.com>

   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Palmmicro nor the names of its contributors may be
	  used to endorse or promote products derived from this software without
	  specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
   DISCLAIMED. IN NO EVENT SHALL COPYRIGHT OWNER BE LIABLE FOR ANY
   DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
   LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
-------------------------------------------------------------------------*/

#include "version.h"
#include "type.h"

#ifdef SLIC_79R70

#include "sfr_gpio.h"
#include "ar168.h"
#include "core.h"
#include "dsp_ext.h"
#include "sfr.h"
#include "apps.h"

#include "bank1.h"

BOOLEAN	SLIC_bFirstRing, SLIC_bTransCID;
UCHAR SLIC_iTimer;

void SLIC_HandleTimer()
{
	SLIC_iTimer ++;
	if (SLIC_iTimer == 1)
	{
		SLIC_Standby();
		if (SLIC_bFirstRing)
		{
			SLIC_bFirstRing = FALSE;
			SLIC_bTransCID = TRUE;
//			DspSetOperation(DSP_OP_CID_GENERATE, DSP_OP_CID_GENERATE);
		}
	}
	else if (SLIC_iTimer >= 4)
	{
		SLIC_Ringing(FALSE);
		SLIC_iTimer = 0;
		if (SLIC_bTransCID)
		{
			SLIC_bTransCID = FALSE;
		}
	}
}

// GPIO A0-SLIC C3, A1-C2, A2-C1, GPIO D5-SLIC B2ENA, EIRQ/GPIO D4-SLIC DETA
void SLIC_Standby()
{
	rGPIO_D |= 0x20;
	rGPIO_A = (rGPIO_A & 0xf8) | 0x05;
}

void SLIC_Ringing(BOOLEAN bFirstRing)
{
	UCHAR pString[40];
	UCHAR iLen1, iLen2;
	USHORT iData;
	PCHAR pCur;
	PCHAR pName;
	PCHAR pNumber;

	if (bFirstRing)
	{
		SLIC_iTimer = 0;
		SLIC_bFirstRing = TRUE;

		// Below is for CID's SDMF
		pCur = pString;
		pName = pString;
#ifdef CALL_NONE
		pNumber = pString;
#else
		pNumber = (PCHAR)TaskGetCallInfo(CALL_INFO_PEER_NUMBER);
#endif
		iLen1 = strlen(pNumber);	// iLen1 is used to save the caller number's length

		pString[0] = 4;
		pString[1] = 8 + iLen1;
//		pString[2] = div_16x8(Sys_tmLocal.iMon, 10) + '0';
//		pString[3] = mod_16x8(Sys_tmLocal.iMon, 10) + '0';
		Fill2Digits((PCHAR)(pString + 2), Sys_tmLocal.iMon);
//		pString[4] = div_16x8(Sys_tmLocal.iMday, 10) + '0';
//		pString[5] = mod_16x8(Sys_tmLocal.iMday, 10) + '0';
		Fill2Digits((PCHAR)(pString + 4), Sys_tmLocal.iMday);
//		pString[6] = div_16x8(Sys_tmLocal.iHour, 10) + '0';
//		pString[7] = mod_16x8(Sys_tmLocal.iHour, 10) + '0';
		Fill2Digits((PCHAR)(pString + 6), Sys_tmLocal.iHour);
//		pString[8] = div_16x8(Sys_tmLocal.iMin, 10) + '0';
//		pString[9] = mod_16x8(Sys_tmLocal.iMin, 10) + '0';
		Fill2Digits((PCHAR)(pString + 8), Sys_tmLocal.iMin);
		memcpy((UCHAR)(pString+10), pNumber, iLen1);

		iLen1 += 10;
		iData = 0;
		for (iLen2 = 0; iLen2 < iLen1; iLen2 ++)	// iLen2 is just a loop counter here
		{
			iData += pString[iLen2];		// iDay is used to save the checksum
		}

		iData >>= 8;
		iData = ~iData;
		iData ++;
		pString[iLen1] = (UCHAR)iData;
		iLen1 ++;

		// Below is for CID's MDMF
/*		pCur = pString;
		pCur += 2;

		pCur[0] = 1;
		pCur[1] = 8;
		pCur[2] = div_16x8(Sys_tmLocal.iMon, 10) + '0';
		pCur[3] = mod_16x8(Sys_tmLocal.iMon, 10) + '0';
		pCur[4] = div_16x8(Sys_tmLocal.iMday, 10) + '0';
		pCur[5] = mod_16x8(Sys_tmLocal.iMday, 10) + '0';
		pCur[6] = div_16x8(Sys_tmLocal.iHour, 10) + '0';
		pCur[7] = mod_16x8(Sys_tmLocal.iHour, 10) + '0';
		pCur[8] = div_16x8(Sys_tmLocal.iMin, 10) + '0';
		pCur[9] = mod_16x8(Sys_tmLocal.iMin, 10) + '0';
		pCur += 10;

		pNumber = (PCHAR)TaskGetCallInfo(CALL_INFO_PEER_NUMBER);
		pName = (PCHAR)TaskGetCallInfo(CALL_INFO_PEER_NAME);

		iLen1 = strlen(pName);	// iLen1 is used to save the caller number's length
		pCur[0] = 2;
		pCur[1] = iLen1;
		memcpy((PCHAR)(pCur+2), pName, iLen1);
		iLen1 += 2;
		pCur += iLen1;

		iLen2 = strlen(pNumber);	// iLen2 is used to save the caller number's length
		pCur[0] = 7;
		pCur[1] = iLen2;
		memcpy((PCHAR)(pCur+2), pNumber, iLen2);
		iLen2 += 2;
		pCur += iLen2;

		iLen1 = 10;
		iLen2 = 10;

		pString[0] = 128;
		pString[1] = 10 + iLen1 + iLen2;

		iLen1 += 12 + iLen2;
		iData = 0;
		for (iLen2 = 0; iLen2 < iLen1; iLen2 ++)	// iLen2 is just a loop counter here
		{
			iData += pString[iLen2];		// iData is used to save the checksum
		}
		iData >>= 8;
		iData = ~iData;
		iData ++;
		pString[iLen1] = (UCHAR)iData;
		iLen1 ++;
*/
		rSRAM_Page = DSP_LOW_8K_PAGE;
		memcpy((PCHAR)(SRAM_BASE+DSP_DEC_BUF), pString, iLen1);
		rSRAM_Page = DEFAULT_MEMORY_PAGE;
	}

	rGPIO_D |= 0x20;
	rGPIO_A = (rGPIO_A & 0xf8) | 0x04;
}

void SLIC_OHT()
{
	rGPIO_D |= 0x20;
	rGPIO_A = (rGPIO_A & 0xf8) | 0x06;
}

void SLIC_Active()
{
	rGPIO_D &= 0xdf;
	rGPIO_A = (rGPIO_A & 0xf8) | 0x02;
}

void SLIC_ActivePR()
{
	rGPIO_D &= 0xdf;
	rGPIO_A = (rGPIO_A & 0xf8) | 0x03;
}

void SLIC_TipOpen()
{
	rGPIO_A = (rGPIO_A & 0xf8) | 0x01;
}

#endif

