// relink.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "relink.h"

#include "..\\common\\common.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

void _RewriteLinkFile(CString strFileName, CString strVer, CString strCall, CString strRes, CString strOem);

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;

using namespace std;

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
	}
	else
	{
		CString strFileName, strVer, strCall, strRes, strOem;
		
		CommandLineDefault(argc, argv, strFileName, strVer, strCall, strRes, strOem);
		_RewriteLinkFile(strFileName, strVer, strCall, strRes, strOem);
	}

	return nRetCode;
}

BOOL _ProcessString(CString & str, CString strVer, CString strCall, CString strRes, CString strOem)
{
	CString strNew;

	if (str.Left(7) != _T("..\\lib\\"))		return FALSE;

	if (str.Right(7) == _T("arp.rel"))
	{
		strNew = _T("..\\lib\\arp.rel");
		if (strVer == _T("ar168o") || strVer == _T("ar168kd"))
		{
			strNew = _T("..\\lib\\dm9003\\arp.rel");
		}
		else if (strVer == _T("ar168p") || strVer == _T("ar168km"))
		{
			strNew = _T("..\\lib\\ksz8842\\arp.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(8) == _T("chip.rel"))
	{
		strNew = _T("..\\lib\\chip.rel");
		if (strVer == _T("ar168k") || strVer == _T("ar168kd") || strVer == _T("ar168km") || strVer == _T("ar168m") || strVer == _T("ar168ms") 
			|| strVer == _T("gp2266") || strVer == _T("bt2008n") || strVer == _T("fwv2800") || strVer == _T("dxdt") || strVer == _T("ar168o") 
			|| strVer == _T("ar168p") || strVer == _T("ar168l") || strVer == _T("ar168ls"))
		{
			strNew = _T("..\\lib\\chip_plus\\chip.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(9) == _T("codec.rel"))
	{
		strNew = _T("..\\lib\\codec.rel");
		if (strVer == _T("ar168k") || strVer == _T("ar168kd") || strVer == _T("ar168km") || strVer == _T("ar168m") || strVer == _T("ar168ms") 
			|| strVer == _T("gp2266") || strVer == _T("bt2008n") || strVer == _T("fwv2800") || strVer == _T("dxdt") || strVer == _T("ar168o") 
			|| strVer == _T("ar168p") || strVer == _T("ar168l") || strVer == _T("ar168ls"))
		{
			strNew = _T("..\\lib\\chip_plus\\codec.rel");
		}
		else if (strVer == _T("gp1266") || strVer == _T("bt2008") || strVer == _T("qx900w") || strVer == _T("ar168j"))
		{
			strNew = _T("..\\lib\\dual_mic\\codec.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(7) == _T("dsp.rel"))
	{
		strNew = _T("..\\lib\\dsp.rel");
		if ((strVer == _T("bt2008n") && strOem == _T("ivr")) || strVer == _T("ar168l") || strVer == _T("ar168ls"))
		{
			strNew = _T("..\\lib\\ivr\\dsp.rel");
		}
		else if (strVer == _T("ar168k") || strVer == _T("ar168kd") || strVer == _T("ar168km") || strVer == _T("ar168m") || strVer == _T("ar168ms") 
			|| strVer == _T("gp2266") || strVer == _T("bt2008n") || strVer == _T("fwv2800") || strVer == _T("dxdt") || strVer == _T("ar168o") 
			|| strVer == _T("ar168p"))
		{
			strNew = _T("..\\lib\\chip_plus\\dsp.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(13) == _T("dsp_bank1.rel"))
	{
		strNew = _T("..\\lib\\dsp_bank1.rel");
		if (strVer == _T("ar168l") || strVer == _T("ar168ls"))
		{
			strNew = _T("..\\lib\\slic\\dsp_bank1.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(9) == _T("flash.rel"))
	{
		strNew = _T("..\\lib\\flash.rel");
		if (strVer == _T("ar168k") || strVer == _T("ar168m") || strVer == _T("ar168l"))
		{
			strNew = _T("..\\lib\\chip_plus\\flash.rel");
		}
		else if (strVer == _T("gp2266") || strVer == _T("bt2008n") || strVer == _T("fwv2800") || strVer == _T("dxdt") || strVer == _T("ar168kd") || strVer == _T("ar168km")
			|| strVer == _T("ar168ms") || strVer == _T("ar168o") || strVer == _T("ar168p") || strVer == _T("ar168ls"))
		{
			strNew = _T("..\\lib\\sst\\flash.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(8) == _T("icmp.rel"))
	{
		strNew = _T("..\\lib\\icmp.rel");
		if (strVer == _T("ar168o") || strVer == _T("ar168kd"))
		{
			strNew = _T("..\\lib\\dm9003\\icmp.rel");
		}
		else if (strVer == _T("ar168p") || strVer == _T("ar168km"))
		{
			strNew = _T("..\\lib\\ksz8842\\icmp.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(6) == _T("ip.rel"))
	{
		strNew = _T("..\\lib\\ip.rel");
		if (strVer == _T("ar168o") || strVer == _T("ar168kd"))
		{
			strNew = _T("..\\lib\\dm9003\\ip.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(7) == _T("isr.rel"))
	{
		strNew = _T("..\\lib\\isr.rel");
		if (strVer == _T("ar168k") || strVer == _T("ar168kd") || strVer == _T("ar168km") || strVer == _T("ar168j") || strVer == _T("gp1266") 
			|| strVer == _T("bt2008") || strVer == _T("qx900w")	|| strVer == _T("ar168l") || strVer == _T("ar168ls"))
		{
			strNew = _T("..\\lib\\key_5x5\\isr.rel");
		}
		else if (strVer == _T("gp2266") || strVer == _T("bt2008n") || strVer == _T("fwv2800") || strVer == _T("dxdt") || strVer == _T("ar168o") || strVer == _T("ar168p"))
		{
			strNew = _T("..\\lib\\key_8x5\\isr.rel");
		}
		else if (strVer == _T("ar168m") || strVer == _T("ar168ms") || (strVer == _T("ar168f") && strOem == _T("uart")))
		{
			strNew = _T("..\\lib\\uart\\isr.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(7) == _T("key.rel"))
	{
		//	ar168j, ar168k, gp1266, bt2008, qx900w, gp2266, bt2008n, fwv2800, ar168f&uart, ar168m, ar168ms, dxdt, ar168o
		strNew = _T("..\\lib\\key.rel");
		if (strVer == _T("gp1266") || strVer == _T("bt2008") || strVer == _T("qx900w"))
		{
			strNew = _T("..\\lib\\key_5x5\\key.rel");
		}
		else if (strVer == _T("ar168k") || strVer == _T("ar168kd") || strVer == _T("ar168km") || strVer == _T("ar168j") || strVer == _T("gp2266") 
			|| strVer == _T("bt2008n") 	|| strVer == _T("fwv2800") || strVer == _T("dxdt") || strVer == _T("ar168o") || strVer == _T("ar168p") 
			|| strVer == _T("ar168l") || strVer == _T("ar168ls"))
		{
			strNew = _T("..\\lib\\key_8x5\\key.rel");
		}
		else if ((strVer == _T("ar168f") && strOem == _T("uart")) || strVer == _T("ar168ms") || strVer == _T("ar168m"))
		{
			strNew = _T("..\\lib\\uart\\key.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(12) == _T("network2.rel"))
	{
		strNew = _T("..\\lib\\network2.rel");
		if (strVer == _T("ar168o") || strVer == _T("ar168kd"))
		{
			strNew = _T("..\\lib\\dm9003\\network2.rel");
		}
		else if (strVer == _T("ar168p") || strVer == _T("ar168km"))
		{
			strNew = _T("..\\lib\\ksz8842\\network2.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(7) == _T("sys.rel"))
	{
		//	gp2266, bt2008n, fwv2800, dxdt, ar168o, ar168ms, ar168kd
		strNew = _T("..\\lib\\sys.rel");
		if (strVer == _T("gp2266") || strVer == _T("bt2008n") || strVer == _T("fwv2800") || strVer == _T("dxdt") || strVer == _T("ar168kd") || strVer == _T("ar168km")
			|| strVer == _T("ar168ms") || strVer == _T("ar168o") || strVer == _T("ar168p") || strVer == _T("ar168ls"))
		{
			strNew = _T("..\\lib\\sst\\sys.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(7) == _T("tcp.rel"))
	{
		strNew = _T("..\\lib\\tcp.rel");
		if (strVer == _T("ar168o") || strVer == _T("ar168kd"))
		{
			// ar168o
			strNew = _T("..\\lib\\dm9003\\tcp.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(8) == _T("uart.rel"))
	{
		// ar168f&uart, ar168m, ar168ms
		strNew = _T("..\\lib\\uart.rel");
		if (strVer == _T("ar168m") || strVer == _T("ar168ms") || (strVer == _T("ar168f") && strOem == _T("uart")))
		{
			strNew = _T("..\\lib\\uart\\uart.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(7) == _T("udp.rel"))
	{
		strNew = _T("..\\lib\\udp.rel");
		if (strVer == _T("ar168o") || strVer == _T("ar168kd"))
		{
			// ar168o
			strNew = _T("..\\lib\\dm9003\\udp.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else if (str.Right(10) == _T("udprun.rel"))
	{
		strNew = _T("..\\lib\\udprun.rel");
		if (strVer == _T("ar168o") || strVer == _T("ar168kd"))
		{
			// ar168o
			strNew = _T("..\\lib\\dm9003\\udprun.rel");
		}
		else if (strVer == _T("ar168p") || strVer == _T("ar168km"))
		{
			strNew = _T("..\\lib\\ksz8842\\udprun.rel");
		}

		if (strNew == str)		return FALSE;
	}
	else
	{
		return FALSE;
	}

	str = strNew;
	return TRUE;
}

void _RewriteLinkFile(CString strFileName, CString strVer, CString strCall, CString strRes, CString strOem)
{
	CStdioFile file;
	CString strName;
	CString str;
	TCHAR szCurDir[128];
	CStringList list;
	POSITION pos, old;
	BOOL bChanged;

	GetCurrentDirectory(128, szCurDir);
	strName.Format(_T("%s\\%s"), szCurDir, strFileName);

	strVer.MakeLower();
	strCall.MakeLower();
	strRes.MakeLower();
	strOem.MakeLower();

	// read first
	if (!file.Open(strName, CFile::modeRead|CFile::typeText))
	{
		return;
	}
	while (file.ReadString(str))
	{
		list.AddTail(str);
	}
	file.Close();

	// process
	bChanged = FALSE;
	for (pos = list.GetHeadPosition(); pos != NULL;)
	{
		old = pos;
		str = list.GetNext(pos);
		if (_ProcessString(str, strVer, strCall, strRes, strOem))
		{
			list.SetAt(old, str);
			bChanged = TRUE;
		}
	}

	if (!bChanged)	return;		// no need to rewrite

	// write
	file.Open(strName, CFile::modeCreate|CFile::modeWrite|CFile::typeText);
	while (!list.IsEmpty())
	{
		str = list.RemoveHead();
		str += _T("\n");
		file.WriteString(str);
	}
	file.Close();
}
