/*-------------------------------------------------------------------------
   Font function copy right information

   Copyright (c) 2006-2010. Lin, Rongrong <woody@palmmicro.com>
                            Alex Gradinar <Alex.Gradinar@cartel.md>

   Original font file from Markus Kuhn <http://www.cl.cam.ac.uk/~mgk25/>

   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Palmmicro nor the names of its contributors may be
	  used to endorse or promote products derived from this software without
	  specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
   DISCLAIMED. IN NO EVENT SHALL COPYRIGHT OWNER BE LIABLE FOR ANY
   DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
   LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
-------------------------------------------------------------------------*/

#include "version.h"
#include "type.h"

// http://www.cs.tut.fi/~jkorpela/iso8859/

// ISO-8859-1 (Latin1)
// Latin1 covers most West European languages, such as French (fr), 
// Spanish (es), Catalan (ca), Basque (eu), Portuguese (pt), Italian (it),
// Albanian (sq), Rhaeto-Romanic (rm), Dutch (nl), German (de), Danish (da),
// Swedish (sv), Norwegian (no), Finnish (fi), Faroese (fo), Icelandic (is),
// Irish (ga), Scottish (gd), and English (en), incidentally also
// Afrikaans (af) and Swahili (sw), thus in effect also the entire American
// continent, Australia and much of Africa. The most notable exceptions are
// Zulu (zu) and other Bantu languages using Latin Extended-B letters, 
// and of course Arabic in North Africa, and Guarani (gn) missing GEIUY with
// ~ tilde. The lack of the ligatures Dutch IJ, French OE and ,,German`` 
// quotation marks is considered tolerable. The lack of the new C=-resembling
// Euro currency symbol U+20AC has opened the discussion of a new Latin0. 

#if defined RES_RO		
// ISO-8859-2 (Latin2), Central and Eastern Europe: Czech (cs), Hungarian (hu), Polish (pl), Romanian (ro), Croatian (hr), Slovak (sk), Slovenian (sl), Sorbian. 
#define ISO_8859_2
#elif defined RES_RU
// ISO-8859-5 (Cyrillic), Bulgarian (bg), Byelorussian (be), Macedonian (mk), Russian (ru), Serbian (sr) and pre-1990 (no ghe with upturn) Ukrainian (uk).
//#define ISO_8859_5
// CP1251 (Windows-1251) (Cyrillic alphabet)
// Russian (RU), Ukrainian (UA), Bulgarian (BG), BELARUS (BY), Macedonian (MK), Serbian (RS)
#define CP1251
#elif defined RES_TR
// ISO-8859-9 (Latin5), Turkish
#define ISO_8859_9
#else
#define ISO_8859_1
#endif

const UCHAR _cFont[] = {
#ifdef DISPLAY_DOT
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //	31	all black status char
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	32	space
0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, //	33	exclam
0x00, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	34	quotedbl
0x00, 0x40, 0xf8, 0x40, 0xf8, 0x40, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x02, 0x1f, 0x02, 0x00, 0x00, //	35	numbersign
0x60, 0x90, 0x10, 0xf8, 0x10, 0x60, 0x00, 0x00, 0x0c, 0x10, 0x11, 0x3f, 0x11, 0x0e, 0x00, 0x00, //	36	dollar
0x30, 0x48, 0x48, 0xf0, 0x20, 0x18, 0x00, 0x00, 0x18, 0x04, 0x0f, 0x12, 0x12, 0x0c, 0x00, 0x00, //	37	percent
0x00, 0x70, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x0a, 0x0c, 0x13, 0x00, 0x00, //	38	ampersand
0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	39	quotesingle
0x00, 0x00, 0xc0, 0x30, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x07, 0x18, 0x20, 0x40, 0x00, 0x00, //	40	parenleft
0x00, 0x04, 0x08, 0x30, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x18, 0x07, 0x00, 0x00, 0x00, //	41	parenright
0x00, 0x40, 0x80, 0xe0, 0x80, 0x40, 0x00, 0x00, 0x00, 0x04, 0x02, 0x0f, 0x02, 0x04, 0x00, 0x00, //	42	asterisk
0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x00, 0x00, //	43	plus
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x38, 0x00, 0x00, 0x00, 0x00, //	44	comma
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, //	45	hyphen
//0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x10, 0x00, 0x00, 0x00, //	46	period
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, // 46 period (Alex)
0x00, 0x00, 0x00, 0xc0, 0x30, 0x0c, 0x00, 0x00, 0x60, 0x18, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, //	47	slash
0xe0, 0x10, 0x08, 0x08, 0x10, 0xe0, 0x00, 0x00, 0x07, 0x08, 0x10, 0x10, 0x08, 0x07, 0x00, 0x00, //	48	zero
0x00, 0x20, 0x10, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	49	one
0x30, 0x08, 0x08, 0x08, 0x88, 0x70, 0x00, 0x00, 0x10, 0x18, 0x14, 0x12, 0x11, 0x10, 0x00, 0x00, //	50	two
0x08, 0x08, 0x88, 0xc8, 0xa8, 0x18, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	51	three
0x00, 0x80, 0x60, 0x10, 0xf8, 0x00, 0x00, 0x00, 0x06, 0x05, 0x04, 0x04, 0x1f, 0x04, 0x00, 0x00, //	52	four
0xf8, 0x48, 0x48, 0x48, 0x48, 0x88, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	53	five
0xe0, 0x10, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	54	six
0x08, 0x08, 0x08, 0x88, 0x68, 0x18, 0x00, 0x00, 0x00, 0x18, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, //	55	seven
0x30, 0x48, 0x88, 0x88, 0x48, 0x30, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00, //	56	eight
0xf0, 0x08, 0x08, 0x08, 0x88, 0xf0, 0x00, 0x00, 0x0c, 0x11, 0x11, 0x11, 0x08, 0x07, 0x00, 0x00, //	57	nine
//0x00, 0x00, 0x40, 0xe0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x00, 0x00, 0x00, //	58	colon
//0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x1c, 0x00, 0x00, 0x00, 0x00, //	59	semicolon
0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, // 58 colon (Alex)
0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x38, 0x00, 0x00, 0x00, 0x00, // 59 semicolon (Alex)
0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x00, 0x00, //	60	less
0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, //	61	equal
0x00, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00, //	62	greater
0x30, 0x08, 0x08, 0x88, 0x48, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, //	63	question
0xe0, 0x10, 0xc8, 0x28, 0x28, 0xf0, 0x00, 0x00, 0x07, 0x08, 0x13, 0x14, 0x14, 0x17, 0x00, 0x00, //	64	at
0xe0, 0x10, 0x08, 0x08, 0x10, 0xe0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, //	65	A
0xf8, 0x88, 0x88, 0x88, 0x50, 0x20, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x09, 0x06, 0x00, 0x00, //	66	B
0xf0, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, //	67	C
0xf8, 0x08, 0x08, 0x08, 0x10, 0xe0, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x08, 0x07, 0x00, 0x00, //	68	D
0xf8, 0x88, 0x88, 0x88, 0x08, 0x08, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, //	69	E
0xf8, 0x88, 0x88, 0x88, 0x08, 0x08, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	70	F
0xf0, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x11, 0x09, 0x1f, 0x00, 0x00, //	71	G
0xf8, 0x80, 0x80, 0x80, 0x80, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	72	H
0x00, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	73	I
0x00, 0x00, 0x00, 0x08, 0xf8, 0x08, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, 0x00, //	74	J
0xf8, 0x80, 0x40, 0x20, 0x10, 0x08, 0x00, 0x00, 0x1f, 0x00, 0x01, 0x02, 0x04, 0x18, 0x00, 0x00, //	75	K
0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, //	76	L
0xf8, 0x30, 0xc0, 0xc0, 0x30, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	77	M
0xf8, 0x60, 0x80, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x01, 0x06, 0x1f, 0x00, 0x00, //	78	N
0xf0, 0x08, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	79	O
0xf8, 0x08, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, //	80	P
0xf0, 0x08, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x14, 0x38, 0x4f, 0x00, 0x00, //	81	Q
0xf8, 0x08, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x03, 0x05, 0x18, 0x00, 0x00, //	82	R
0x70, 0x88, 0x88, 0x08, 0x08, 0x30, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x11, 0x11, 0x0e, 0x00, 0x00, //	83	S
0x08, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, //	84	T
0xf8, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	85	U
0x78, 0x80, 0x00, 0x00, 0x80, 0x78, 0x00, 0x00, 0x00, 0x03, 0x1c, 0x1c, 0x03, 0x00, 0x00, 0x00, //	86	V
0x00, 0xf8, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x0e, 0x10, 0x0f, 0x00, 0x00, //	87	W
0x18, 0x60, 0x80, 0x80, 0x60, 0x18, 0x00, 0x00, 0x18, 0x06, 0x01, 0x01, 0x06, 0x18, 0x00, 0x00, //	88	X
0x00, 0x38, 0xc0, 0x00, 0xc0, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, //	89	Y
0x08, 0x08, 0x08, 0xc8, 0x28, 0x18, 0x00, 0x00, 0x18, 0x16, 0x11, 0x10, 0x10, 0x10, 0x00, 0x00, //	90	Z
0x00, 0x00, 0xfc, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x40, 0x40, 0x40, 0x00, 0x00, //	91	bracketleft
0x0c, 0x30, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x18, 0x60, 0x00, 0x00, //	92	backslash
0x00, 0x04, 0x04, 0x04, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x7f, 0x00, 0x00, 0x00, //	93	bracketright
0x10, 0x08, 0x04, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	94	asciicircum
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, //	95	underscore
0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	96	grave
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	97	a
0xf8, 0x80, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x1f, 0x08, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	98	b
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, //	99	c
0x80, 0x40, 0x40, 0x40, 0x80, 0xf8, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x1f, 0x00, 0x00, //	100	d
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x0b, 0x00, 0x00, //	101	e
0x80, 0x80, 0xf0, 0x88, 0x88, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, //	102	f
0x80, 0x40, 0x40, 0x40, 0x80, 0x40, 0x00, 0x00, 0x33, 0x4c, 0x54, 0x54, 0x53, 0x20, 0x00, 0x00, //	103	g
0xf8, 0x80, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	104	h
0x00, 0x00, 0x40, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	105	i
0x00, 0x00, 0x00, 0x00, 0x40, 0xd8, 0x00, 0x00, 0x00, 0x30, 0x40, 0x40, 0x40, 0x3f, 0x00, 0x00, //	106	j
0xf8, 0x00, 0x00, 0x80, 0x40, 0x00, 0x00, 0x00, 0x1f, 0x02, 0x03, 0x04, 0x08, 0x10, 0x00, 0x00, //	107	k
0x00, 0x00, 0x08, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	108	l
0x00, 0xc0, 0x40, 0x80, 0x40, 0x80, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x0f, 0x00, 0x1f, 0x00, 0x00, //	109	m
0xc0, 0x80, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	110	n
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	111	o
0xc0, 0x80, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x7f, 0x08, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	112	p
0x80, 0x40, 0x40, 0x40, 0x80, 0xc0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x7f, 0x00, 0x00, //	113	q
0xc0, 0x80, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, //	114	r
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x08, 0x11, 0x12, 0x12, 0x14, 0x08, 0x00, 0x00, //	115	s
0x40, 0x40, 0xf8, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x08, 0x00, 0x00, //	116	t
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x1f, 0x00, 0x00, //	117	u
0x00, 0xc0, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x06, 0x18, 0x06, 0x01, 0x00, 0x00, //	118	v
0x00, 0xc0, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x0f, 0x10, 0x0f, 0x00, 0x00, //	119	w
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x18, 0x05, 0x02, 0x02, 0x05, 0x18, 0x00, 0x00, //	120	x
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x27, 0x48, 0x48, 0x48, 0x44, 0x3f, 0x00, 0x00, //	121	y
0x40, 0x40, 0x40, 0x40, 0xc0, 0x40, 0x00, 0x00, 0x10, 0x18, 0x16, 0x11, 0x10, 0x10, 0x00, 0x00, //	122	z
0x00, 0x00, 0x00, 0xf8, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3e, 0x40, 0x40, 0x00, 0x00, //	123	braceleft
0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, //	124	bar
0x00, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x3e, 0x01, 0x00, 0x00, 0x00, //	125	braceright
0x18, 0x04, 0x08, 0x10, 0x20, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	126	asciitilde
#ifdef CP1251
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	127 make it all here!
0x08, 0x08, 0xf8, 0x48, 0x48, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x40, 0x40, 0x3f, 0x00, 0x00, //	128	CYRILLIC CAPITAL LETTER DJE
0xf0, 0x10, 0x14, 0x12, 0x10, 0x10, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	129	CYRILLIC CAPITAL LETTER GJE
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x18, 0x00, 0x00, 0x00, 0x00, //	130	SINGLE LOW-9 QUOTATION MARK
0x00, 0xc0, 0x40, 0x50, 0x48, 0x40, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	131	CYRILLIC SMALL LETTER GJE
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x18, 0x00, 0x28, 0x18, 0x00, 0x00, //	132	DOUBLE LOW-9 QUOTATION MARK
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, //	133	HORIZONTAL ELLIPSIS
0x00, 0x40, 0x40, 0xf0, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, //	134	DAGGER
0x00, 0x40, 0x40, 0xf0, 0x40, 0x40, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00, //	135	DOUBLE DAGGER
0x80, 0xe0, 0x90, 0x10, 0x10, 0x20, 0x00, 0x00, 0x02, 0x0f, 0x12, 0x10, 0x10, 0x08, 0x00, 0x00, //	136	EURO SIGN
0x20, 0x50, 0x20, 0x80, 0x40, 0x30, 0x00, 0x00, 0x18, 0x04, 0x0a, 0x15, 0x08, 0x14, 0x08, 0x00, //	137	PER MILLE SIGN
0x00, 0xf8, 0x08, 0xf8, 0x80, 0x00, 0x00, 0x00, 0x10, 0x0f, 0x00, 0x1f, 0x10, 0x0f, 0x00, 0x00, //	138	CYRILLIC CAPITAL LETTER LJE
0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x08, 0x10, 0x00, 0x00, 0x00, //	139	SINGLE LEFT-POINTING ANGLE QUOTATION MARK
0xf8, 0x80, 0x80, 0xf8, 0x80, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x10, 0x0f, 0x00, 0x00, //	140	CYRILLIC CAPITAL LETTER NJE
0xf0, 0x00, 0x84, 0x42, 0x20, 0x10, 0x00, 0x00, 0x1f, 0x01, 0x02, 0x04, 0x08, 0x10, 0x00, 0x00, //	141	CYRILLIC CAPITAL LETTER KJE
0x08, 0x08, 0xf8, 0x48, 0x48, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x00, 0x00, //	142	CYRILLIC CAPITAL LETTER TSHE
0x00, 0xf8, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x30, 0x10, 0x1f, 0x00, 0x00, //	143	CYRILLIC CAPITAL LETTER DZHE
0x20, 0xf8, 0xa0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x40, 0x40, 0x3f, 0x00, 0x00, //	144	CYRILLIC SMALL LETTER DJE
0x00, 0x00, 0x30, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	145	LEFT SINGLE QUOTATION MARK
0x00, 0x00, 0x28, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	146	RIGHT SINGLE QUOTATION MARK
0x00, 0x30, 0x28, 0x00, 0x30, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	147	LEFT DOUBLE QUOTATION MARK
0x00, 0x28, 0x18, 0x00, 0x28, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	148	RIGHT DOUBLE QUOTATION MARK
0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0f, 0x0f, 0x0f, 0x07, 0x00, 0x00, //	149	BULLET
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, //	150	EN DASH
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, //	151	EM DASH
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	152 missing char!
0x02, 0x1e, 0x02, 0x1e, 0x06, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	153	TRADE MARK SIGN
0x00, 0xc0, 0x40, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0f, 0x00, 0x1f, 0x12, 0x0c, 0x00, 0x00, //	154	CYRILLIC SMALL LETTER LJE
0x00, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x05, 0x02, 0x00, 0x00, 0x00, //	155	SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
0xc0, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x02, 0x02, 0x1f, 0x12, 0x0c, 0x00, 0x00, //	156	CYRILLIC SMALL LETTER NJE
0xc0, 0x00, 0x10, 0x08, 0x80, 0x40, 0x00, 0x00, 0x1f, 0x04, 0x02, 0x05, 0x08, 0x10, 0x00, 0x00, //	157	CYRILLIC SMALL LETTER KJE
0x10, 0x10, 0xf8, 0x50, 0x50, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x00, 0x00, //	158	CYRILLIC SMALL LETTER TSHE
0x00, 0xc0, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x30, 0x10, 0x1f, 0x00, 0x00, //	159	CYRILLIC SMALL LETTER DZHE
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	160	NO-BREAK SPACE
0x00, 0x32, 0xc4, 0x04, 0xc4, 0x32, 0x00, 0x00, 0x00, 0x18, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, //	161	CYRILLIC CAPITAL LETTER SHORT U
0xc8, 0x10, 0x10, 0x10, 0x10, 0xc8, 0x00, 0x00, 0x27, 0x48, 0x48, 0x48, 0x44, 0x3f, 0x00, 0x00, //	162	CYRILLIC SMALL LETTER SHORT U
0x00, 0x00, 0x00, 0x08, 0xf8, 0x08, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, 0x00, //	163	CYRILLIC CAPITAL LETTER JE
0x20, 0xc0, 0x40, 0x40, 0xc0, 0x20, 0x00, 0x00, 0x04, 0x03, 0x02, 0x02, 0x03, 0x04, 0x00, 0x00, //	164	CURRENCY SIGN
0xf8, 0x08, 0x08, 0x08, 0x08, 0x0c, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	165	CYRILLIC CAPITAL LETTER GHE WITH UPTURN
0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, //	166	BROKEN BAR
0x88, 0x54, 0x24, 0x24, 0x44, 0x88, 0x00, 0x00, 0x08, 0x11, 0x12, 0x12, 0x15, 0x08, 0x00, 0x00, //	167	SECTION SIGN
0xf0, 0x16, 0x10, 0x10, 0x16, 0x10, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, //	168	CYRILLIC CAPITAL LETTER IO
0xf8, 0xe4, 0x14, 0x14, 0x24, 0xf8, 0x00, 0x00, 0x0f, 0x13, 0x14, 0x14, 0x12, 0x0f, 0x00, 0x00, //	169	COPYRIGHT SIGN
0xe0, 0x90, 0x88, 0x88, 0x08, 0x10, 0x00, 0x00, 0x07, 0x08, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, //	170	CYRILLIC CAPITAL LETTER UKRAINIAN IE
0x00, 0x00, 0x80, 0x40, 0x80, 0x40, 0x00, 0x00, 0x02, 0x05, 0x0a, 0x15, 0x08, 0x10, 0x00, 0x00, //	171	LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x00, 0x00, //	172	NOT SIGN
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, //	173	SOFT HYPHEN
0xf8, 0xf4, 0x94, 0x94, 0x64, 0xf8, 0x00, 0x00, 0x0f, 0x17, 0x10, 0x10, 0x17, 0x0f, 0x00, 0x00, //	174	REGISTERED SIGN
0x00, 0x10, 0x14, 0xf0, 0x14, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	175	CYRILLIC CAPITAL LETTER YI
0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	176	DEGREE SIGN
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x1f, 0x12, 0x12, 0x00, 0x00, //	177	PLUS-MINUS SIGN
0x00, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	178	CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
0x00, 0x00, 0x40, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	179	CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
0x00, 0xc0, 0x40, 0x40, 0x40, 0x60, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	180	CYRILLIC SMALL LETTER GHE WITH UPTURN
0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x10, 0x08, 0x1f, 0x00, 0x00, //	181	MICRO SIGN
0x00, 0xf0, 0x08, 0xf8, 0x08, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7f, 0x40, 0x7f, 0x00, 0x00, //	182	PILCROW SIGN
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	183	MIDDLE DOT
0x80, 0x58, 0x40, 0x40, 0x58, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x0b, 0x00, 0x00, //	184	CYRILLIC SMALL LETTER IO
0xf8, 0x40, 0x80, 0xf8, 0x80, 0x40, 0x80, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x13, 0x14, 0x13, 0x00, //	185	NUMERO SIGN
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x10, 0x08, 0x00, 0x00, //	186	CYRILLIC SMALL LETTER UKRAINIAN IE
0x40, 0x80, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x15, 0x0a, 0x05, 0x02, 0x00, 0x00, //	187	RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
0x00, 0x00, 0x00, 0x00, 0x40, 0xd8, 0x00, 0x00, 0x00, 0x30, 0x40, 0x40, 0x40, 0x3f, 0x00, 0x00, //	188	CYRILLIC SMALL LETTER JE
0x70, 0x88, 0x88, 0x08, 0x08, 0x30, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x11, 0x11, 0x0e, 0x00, 0x00, //	189	CYRILLIC CAPITAL LETTER DZE
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x08, 0x11, 0x12, 0x12, 0x14, 0x08, 0x00, 0x00, //	190	CYRILLIC SMALL LETTER DZE
0x00, 0x00, 0x58, 0xc0, 0x18, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	191	CYRILLIC SMALL LETTER YI
0xe0, 0x10, 0x08, 0x08, 0x10, 0xe0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, //	192	CYRILLIC CAPITAL LETTER A
0xf8, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	193	CYRILLIC CAPITAL LETTER BE
0xf8, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	194	CYRILLIC CAPITAL LETTER VE
0xf8, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	195	CYRILLIC CAPITAL LETTER GHE
0x00, 0x00, 0xf8, 0x08, 0xf8, 0x00, 0x00, 0x00, 0x30, 0x1f, 0x10, 0x10, 0x1f, 0x30, 0x00, 0x00, //	196	CYRILLIC CAPITAL LETTER DE
0xf8, 0x88, 0x88, 0x88, 0x08, 0x08, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, //	197	CYRILLIC CAPITAL LETTER IE
0x00, 0x78, 0x80, 0xf8, 0x80, 0x78, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, //	198	CYRILLIC CAPITAL LETTER ZHE
0x10, 0x08, 0x88, 0x88, 0x50, 0x20, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x09, 0x06, 0x00, 0x00, //	199	CYRILLIC CAPITAL LETTER ZE
0xf8, 0x00, 0x00, 0x80, 0x60, 0xf8, 0x00, 0x00, 0x1f, 0x06, 0x01, 0x00, 0x00, 0x1f, 0x00, 0x00, //	200	CYRILLIC CAPITAL LETTER I
0xf2, 0x04, 0x04, 0x84, 0x64, 0xf2, 0x00, 0x00, 0x1f, 0x06, 0x01, 0x00, 0x00, 0x1f, 0x00, 0x00, //	201	CYRILLIC CAPITAL LETTER SHORT I
0xf8, 0x80, 0x40, 0x20, 0x10, 0x08, 0x00, 0x00, 0x1f, 0x00, 0x01, 0x02, 0x04, 0x18, 0x00, 0x00, //	202	CYRILLIC CAPITAL LETTER KA
0x00, 0x00, 0xf8, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x08, 0x10, 0x0f, 0x00, 0x00, 0x1f, 0x00, 0x00, //	203	CYRILLIC CAPITAL LETTER EL
0xf8, 0x30, 0xc0, 0xc0, 0x30, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	204	CYRILLIC CAPITAL LETTER EM
0xf8, 0x80, 0x80, 0x80, 0x80, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	205	CYRILLIC CAPITAL LETTER EN
0xf0, 0x08, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	206	CYRILLIC CAPITAL LETTER O
0x08, 0xf8, 0x08, 0x08, 0xf8, 0x08, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, //	207	CYRILLIC CAPITAL LETTER PE
0xf8, 0x08, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, //	208	CYRILLIC CAPITAL LETTER ER
0xf0, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, //	209	CYRILLIC CAPITAL LETTER ES
0x00, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, //	210	CYRILLIC CAPITAL LETTER TE
0xf8, 0x00, 0x00, 0x00, 0x80, 0xf8, 0x00, 0x00, 0x08, 0x11, 0x11, 0x11, 0x08, 0x07, 0x00, 0x00, //	211	CYRILLIC CAPITAL LETTER U
0x00, 0xe0, 0x10, 0xf8, 0x10, 0xe0, 0x00, 0x00, 0x00, 0x07, 0x08, 0x1f, 0x08, 0x07, 0x00, 0x00, //	212	CYRILLIC CAPITAL LETTER EF
0x18, 0x60, 0x80, 0x80, 0x60, 0x18, 0x00, 0x00, 0x18, 0x06, 0x01, 0x01, 0x06, 0x18, 0x00, 0x00, //	213	CYRILLIC CAPITAL LETTER HA
0xf8, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x1f, 0x70, 0x00, 0x00, //	214	CYRILLIC CAPITAL LETTER TSE
0x78, 0x80, 0x80, 0x80, 0x80, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	215	CYRILLIC CAPITAL LETTER CHE
0x00, 0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x1f, 0x10, 0x1f, 0x00, 0x00, //	216	CYRILLIC CAPITAL LETTER SHA
0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x1f, 0x10, 0x1f, 0x70, 0x00, 0x00, //	217	CYRILLIC CAPITAL LETTER SHCHA
0x08, 0x08, 0xf8, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x0f, 0x00, 0x00, //	218	CYRILLIC CAPITAL LETTER HARD SIGN
0xf8, 0x80, 0x80, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x0f, 0x00, 0x1f, 0x00, 0x00, //	219	CYRILLIC CAPITAL LETTER YERU
0x00, 0xf8, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	220	CYRILLIC CAPITAL LETTER SOFT SIGN
0x10, 0x08, 0x88, 0x88, 0x90, 0xe0, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x08, 0x07, 0x00, 0x00, //	221	CYRILLIC CAPITAL LETTER E
0xf8, 0x80, 0xf0, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x1f, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x00, //	222	CYRILLIC CAPITAL LETTER YU
0xf0, 0x08, 0x08, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x18, 0x05, 0x03, 0x01, 0x01, 0x1f, 0x00, 0x00, //	223	CYRILLIC CAPITAL LETTER YA
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	224	CYRILLIC SMALL LETTER A
0xe0, 0x90, 0x50, 0x50, 0x48, 0x88, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	225	CYRILLIC SMALL LETTER BE
0xc0, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x12, 0x12, 0x0d, 0x00, 0x00, //	226	CYRILLIC SMALL LETTER VE
0x00, 0xc0, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	227	CYRILLIC SMALL LETTER GHE
0x00, 0x00, 0xc0, 0x40, 0xc0, 0x00, 0x00, 0x00, 0x30, 0x1e, 0x11, 0x10, 0x1f, 0x30, 0x00, 0x00, //	228	CYRILLIC SMALL LETTER DE
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x0b, 0x00, 0x00, //	229	CYRILLIC SMALL LETTER IE
0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x1d, 0x02, 0x1f, 0x02, 0x1d, 0x00, 0x00, //	230	CYRILLIC SMALL LETTER ZHE
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x08, 0x10, 0x10, 0x12, 0x12, 0x0d, 0x00, 0x00, //	231	CYRILLIC SMALL LETTER ZE
0xc0, 0x00, 0x00, 0x00, 0x80, 0xc0, 0x00, 0x00, 0x1f, 0x04, 0x02, 0x01, 0x00, 0x1f, 0x00, 0x00, //	232	CYRILLIC SMALL LETTER I
0xc8, 0x10, 0x10, 0x10, 0x90, 0xc8, 0x00, 0x00, 0x1f, 0x04, 0x02, 0x01, 0x00, 0x1f, 0x00, 0x00, //	233	CYRILLIC SMALL LETTER SHORT I
0xc0, 0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x00, 0x1f, 0x04, 0x02, 0x05, 0x08, 0x10, 0x00, 0x00, //	234	CYRILLIC SMALL LETTER KA
0x00, 0x00, 0xc0, 0x40, 0x40, 0xc0, 0x00, 0x00, 0x10, 0x10, 0x0f, 0x00, 0x00, 0x1f, 0x00, 0x00, //	235	CYRILLIC SMALL LETTER EL
0xc0, 0x80, 0x00, 0x00, 0x80, 0xc0, 0x00, 0x00, 0x1f, 0x01, 0x06, 0x06, 0x01, 0x1f, 0x00, 0x00, //	236	CYRILLIC SMALL LETTER EM
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x1f, 0x02, 0x02, 0x02, 0x02, 0x1f, 0x00, 0x00, //	237	CYRILLIC SMALL LETTER EN
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	238	CYRILLIC SMALL LETTER O
0xc0, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	239	CYRILLIC SMALL LETTER PE
0xc0, 0x80, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x7f, 0x08, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	240	CYRILLIC SMALL LETTER ER
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, //	241	CYRILLIC SMALL LETTER ES
0x00, 0x40, 0x40, 0xc0, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, //	242	CYRILLIC SMALL LETTER TE
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x27, 0x48, 0x48, 0x48, 0x44, 0x3f, 0x00, 0x00, //	243	CYRILLIC SMALL LETTER U
0x00, 0x80, 0x40, 0xf0, 0x40, 0x80, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x7f, 0x10, 0x0f, 0x00, 0x00, //	244	CYRILLIC SMALL LETTER EF
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x18, 0x05, 0x02, 0x02, 0x05, 0x18, 0x00, 0x00, //	245	CYRILLIC SMALL LETTER HA
0xc0, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x1f, 0x70, 0x00, 0x00, //	246	CYRILLIC SMALL LETTER TSE
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x01, 0x02, 0x02, 0x02, 0x02, 0x1f, 0x00, 0x00, //	247	CYRILLIC SMALL LETTER CHE
0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x1f, 0x10, 0x1f, 0x00, 0x00, //	248	CYRILLIC SMALL LETTER SHA
0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x1f, 0x10, 0x1f, 0x70, 0x00, 0x00, //	249	CYRILLIC SMALL LETTER SHCHA
0x40, 0x40, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x0c, 0x00, 0x00, //	250	CYRILLIC SMALL LETTER HARD SIGN
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x0c, 0x00, 0x1f, 0x00, 0x00, //	251	CYRILLIC SMALL LETTER YERU
0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, //	252	CYRILLIC SMALL LETTER SOFT SIGN
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x08, 0x10, 0x12, 0x12, 0x12, 0x0f, 0x00, 0x00, //	253	CYRILLIC SMALL LETTER E
0xc0, 0x00, 0x80, 0x40, 0x40, 0x80, 0x00, 0x00, 0x1f, 0x02, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x00, //	254	CYRILLIC SMALL LETTER YU
0x80, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x00, 0x00, 0x11, 0x0a, 0x06, 0x02, 0x02, 0x1f, 0x00, 0x00, //	255	CYRILLIC SMALL LETTER YA
#elif defined ISO_8859_2
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	160	space
0xe0, 0x10, 0x08, 0x08, 0x10, 0xe0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x21, 0x5f, 0x40, 0x00, //	260	Aogonek
0x00, 0x04, 0x08, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	728	breve
0x00, 0x00, 0xf8, 0x80, 0x40, 0x00, 0x00, 0x00, 0x02, 0x01, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x00, //	321	Lslash
0x20, 0xc0, 0x40, 0x40, 0xc0, 0x20, 0x00, 0x00, 0x04, 0x03, 0x02, 0x02, 0x03, 0x04, 0x00, 0x00, //	164	currency
0xe4, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, //	317	Lcaron
0xe0, 0x10, 0x14, 0x12, 0x10, 0x20, 0x00, 0x00, 0x0c, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, //	346	Sacute
0x88, 0x54, 0x24, 0x24, 0x44, 0x88, 0x00, 0x00, 0x08, 0x11, 0x12, 0x12, 0x15, 0x08, 0x00, 0x00, //	167	section
0x00, 0x0c, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	168	dieresis
0x60, 0x92, 0x94, 0x14, 0x12, 0x60, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x11, 0x11, 0x0e, 0x00, 0x00, //	352	Scaron
0x70, 0x88, 0x88, 0x08, 0x08, 0x30, 0x00, 0x00, 0x0c, 0x10, 0x50, 0x31, 0x11, 0x0e, 0x00, 0x00, //	350	Scedilla
0x10, 0x10, 0x12, 0xf4, 0x14, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, //	356	Tcaron
0x10, 0x10, 0x14, 0xd2, 0x30, 0x10, 0x00, 0x00, 0x18, 0x16, 0x11, 0x10, 0x10, 0x10, 0x00, 0x00, //	377	Zacute
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, //	173	hyphen
0x10, 0x12, 0x14, 0xd4, 0x32, 0x10, 0x00, 0x00, 0x18, 0x16, 0x11, 0x10, 0x10, 0x10, 0x00, 0x00, //	381	Zcaron
0x10, 0x10, 0x14, 0xd4, 0x30, 0x10, 0x00, 0x00, 0x18, 0x16, 0x11, 0x10, 0x10, 0x10, 0x00, 0x00, //	379	Zdotaccent
0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	176	degree
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x32, 0x5f, 0x40, 0x00, //	261	aogonek
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00, //	731	ogonek
0x00, 0x00, 0x08, 0xf8, 0x80, 0x40, 0x00, 0x00, 0x00, 0x12, 0x11, 0x1f, 0x10, 0x10, 0x00, 0x00, //	322	lslash
0x00, 0x00, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	180	acute
0x00, 0x02, 0x14, 0xf4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	318	lcaron
0x80, 0x40, 0x50, 0x48, 0x40, 0x80, 0x00, 0x00, 0x08, 0x11, 0x12, 0x12, 0x14, 0x08, 0x00, 0x00, //	347	sacute
0x00, 0x00, 0x04, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	711	caron
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x30, 0x00, 0x00, 0x00, 0x00, //	184	cedilla
0x80, 0x48, 0x50, 0x50, 0x48, 0x80, 0x00, 0x00, 0x08, 0x11, 0x12, 0x12, 0x14, 0x08, 0x00, 0x00, //	353	scaron
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x08, 0x11, 0x52, 0x32, 0x14, 0x08, 0x00, 0x00, //	351	scedilla
0x40, 0x42, 0xf4, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x08, 0x00, 0x00, //	357	tcaron
0x40, 0x40, 0x50, 0x48, 0xc0, 0x40, 0x00, 0x00, 0x10, 0x18, 0x16, 0x11, 0x10, 0x10, 0x00, 0x00, //	378	zacute
0x00, 0x08, 0x04, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	733	hungarumlaut
0x40, 0x48, 0x50, 0x50, 0xc8, 0x40, 0x00, 0x00, 0x10, 0x18, 0x16, 0x11, 0x10, 0x10, 0x00, 0x00, //	382	zcaron
0x40, 0x40, 0x50, 0x50, 0xc0, 0x40, 0x00, 0x00, 0x10, 0x18, 0x16, 0x11, 0x10, 0x10, 0x00, 0x00, //	380	zdotaccent
0xf0, 0x10, 0x14, 0x12, 0x10, 0xe0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x03, 0x05, 0x18, 0x00, 0x00, //	340	Racute
0xc0, 0x20, 0x14, 0x12, 0x20, 0xc0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, //	193	Aacute
0xc0, 0x24, 0x12, 0x12, 0x24, 0xc0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, //	194	Acircumflex
0xc2, 0x24, 0x14, 0x14, 0x24, 0xc2, 0x00, 0x00, 0x1f, 0x02, 0x02, 0x02, 0x02, 0x1f, 0x00, 0x00, //	258	Abreve
0xc0, 0x24, 0x10, 0x10, 0x24, 0xc0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, //	196	Adieresis
0xf4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, //	313	Lacute
0xe0, 0x10, 0x14, 0x12, 0x10, 0x60, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, //	262	Cacute
0xf0, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x0f, 0x10, 0x50, 0x30, 0x10, 0x0c, 0x00, 0x00, //	199	Ccedilla
0xe0, 0x12, 0x14, 0x14, 0x12, 0x60, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, //	268	Ccaron
0xf0, 0x10, 0x14, 0x12, 0x10, 0x10, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, //	201	Eacute
0xf8, 0x88, 0x88, 0x88, 0x08, 0x08, 0x00, 0x00, 0x1f, 0x10, 0x30, 0x50, 0x10, 0x10, 0x00, 0x00, //	280	Eogonek
0xf0, 0x14, 0x10, 0x10, 0x14, 0x10, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, //	203	Edieresis
0xf0, 0x12, 0x14, 0x14, 0x12, 0x10, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00, 0x00, //	282	Ecaron
0x00, 0x10, 0x10, 0xf4, 0x12, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	205	Iacute
0x00, 0x10, 0x14, 0xf2, 0x14, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	206	Icircumflex
0xf0, 0x12, 0x14, 0x14, 0x22, 0xc0, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x08, 0x07, 0x00, 0x00, //	270	Dcaron
0x80, 0xf8, 0x88, 0x08, 0x08, 0x10, 0xe0, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x08, 0x07, 0x00, //	272	Dcroat
0xf0, 0x60, 0x84, 0x02, 0x00, 0xf0, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x01, 0x06, 0x1f, 0x00, 0x00, //	323	Nacute
0xf8, 0x62, 0x84, 0x04, 0x02, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x01, 0x06, 0x1f, 0x00, 0x00, //	327	Ncaron
0xe0, 0x10, 0x14, 0x12, 0x10, 0xe0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	211	Oacute
0xe0, 0x14, 0x12, 0x12, 0x14, 0xe0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	212	Ocircumflex
0xe0, 0x14, 0x12, 0x10, 0x14, 0xe2, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	336	Ohungarumlaut
0xe0, 0x14, 0x10, 0x10, 0x14, 0xe0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	214	Odieresis
0x40, 0x80, 0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x10, 0x08, 0x05, 0x02, 0x05, 0x08, 0x10, 0x00, //	215	multiply
0xf0, 0x12, 0x14, 0x14, 0x12, 0xe0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x03, 0x05, 0x18, 0x00, 0x00, //	344	Rcaron
0xf0, 0x04, 0x0a, 0x0a, 0x04, 0xf0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	366	Uring
0xf0, 0x00, 0x04, 0x02, 0x00, 0xf0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	218	Uacute
0xf0, 0x04, 0x02, 0x00, 0x04, 0xf2, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	368	Uhungarumlaut
0xf0, 0x04, 0x00, 0x00, 0x04, 0xf0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	220	Udieresis
0x00, 0x30, 0xc0, 0x04, 0xc2, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, //	221	Yacute
0x08, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x20, 0x00, 0x00, 0x00, //	354	Tcommaaccent
0x00, 0xf0, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x10, 0x1f, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00, //	223	germandbls
0xc0, 0x80, 0x50, 0x48, 0x40, 0x80, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, //	341	racute
0x80, 0x40, 0x40, 0x50, 0x48, 0x80, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	225	aacute
0x80, 0x50, 0x48, 0x48, 0x50, 0x80, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	226	acircumflex
0x88, 0x50, 0x50, 0x50, 0x50, 0x88, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	259	abreve
0x80, 0x50, 0x40, 0x40, 0x50, 0x80, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	228	adieresis
0x00, 0x00, 0x14, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	314	lacute
0x80, 0x40, 0x50, 0x48, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, //	263	cacute
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x50, 0x30, 0x10, 0x08, 0x00, 0x00, //	231	ccedilla
0x80, 0x48, 0x50, 0x50, 0x48, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, //	269	ccaron
0x80, 0x40, 0x50, 0x48, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x0b, 0x00, 0x00, //	233	eacute
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x32, 0x52, 0x12, 0x0b, 0x00, 0x00, //	281	eogonek
0x80, 0x50, 0x40, 0x40, 0x50, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x0b, 0x00, 0x00, //	235	edieresis
0x80, 0x48, 0x50, 0x50, 0x48, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x0b, 0x00, 0x00, //	283	ecaron
0x00, 0x00, 0x40, 0xd0, 0x08, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	237	iacute
0x00, 0x10, 0x48, 0xc8, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	238	icircumflex
0x80, 0x44, 0x48, 0x48, 0x84, 0xf0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x1f, 0x00, 0x00, //	271	dcaron
0x80, 0x40, 0x50, 0x50, 0x90, 0xf8, 0x10, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x1f, 0x00, 0x00, //	273	dcroat
0xc0, 0x80, 0x50, 0x48, 0x40, 0x80, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	324	nacute
0xc0, 0x88, 0x50, 0x50, 0x48, 0x80, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	328	ncaron
0x80, 0x40, 0x50, 0x48, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	243	oacute
0x80, 0x50, 0x48, 0x48, 0x50, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	244	ocircumflex
0x80, 0x50, 0x48, 0x40, 0x50, 0x88, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	337	ohungarumlaut
0x80, 0x50, 0x40, 0x40, 0x50, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	246	odieresis
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x15, 0x15, 0x04, 0x04, 0x00, 0x00, //	247	divide
0xc0, 0x88, 0x50, 0x50, 0x48, 0x80, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, //	345	rcaron
0xc0, 0x08, 0x14, 0x14, 0x08, 0xc0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x1f, 0x00, 0x00, //	367	uring
0xc0, 0x00, 0x10, 0x08, 0x00, 0xc0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x1f, 0x00, 0x00, //	250	uacute
0xc0, 0x10, 0x08, 0x00, 0x10, 0xc8, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x1f, 0x00, 0x00, //	369	uhungarumlaut
0xc0, 0x10, 0x00, 0x00, 0x10, 0xc0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x1f, 0x00, 0x00, //	252	udieresis
0xc0, 0x00, 0x10, 0x08, 0x00, 0xc0, 0x00, 0x00, 0x20, 0x43, 0x4c, 0x38, 0x0e, 0x01, 0x00, 0x00, //	253	yacute
0x40, 0x40, 0xf8, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x50, 0x30, 0x08, 0x00, 0x00, //	355	tcommaaccent
0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	729	dotaccent
#elif defined ISO_8859_5
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	160	space
0xf0, 0x16, 0x10, 0x10, 0x16, 0x10, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, //	1025	afii10023
0x08, 0x08, 0xf8, 0x48, 0x48, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x40, 0x40, 0x3f, 0x00, 0x00, //	1026	afii10051
0xf0, 0x10, 0x14, 0x12, 0x10, 0x10, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	1027	afii10052
0xe0, 0x90, 0x88, 0x88, 0x08, 0x10, 0x00, 0x00, 0x07, 0x08, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, //	1028	afii10053
0x70, 0x88, 0x88, 0x08, 0x08, 0x30, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x11, 0x11, 0x0e, 0x00, 0x00, //	1029	afii10054
0x00, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	1030	afii10055
0x00, 0x10, 0x14, 0xf0, 0x14, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	1031	afii10056
0x00, 0x00, 0x00, 0x08, 0xf8, 0x08, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, 0x00, //	1032	afii10057
0x00, 0xf8, 0x08, 0xf8, 0x80, 0x00, 0x00, 0x00, 0x10, 0x0f, 0x00, 0x1f, 0x10, 0x0f, 0x00, 0x00, //	1033	afii10058
0xf8, 0x80, 0x80, 0xf8, 0x80, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x10, 0x0f, 0x00, 0x00, //	1034	afii10059
0x08, 0x08, 0xf8, 0x48, 0x48, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x00, 0x00, //	1035	afii10060
0xf0, 0x00, 0x84, 0x42, 0x20, 0x10, 0x00, 0x00, 0x1f, 0x01, 0x02, 0x04, 0x08, 0x10, 0x00, 0x00, //	1036	afii10061
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, //	173	hyphen
0x00, 0x32, 0xc4, 0x04, 0xc4, 0x32, 0x00, 0x00, 0x00, 0x18, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, //	1038	afii10062
0x00, 0xf8, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x30, 0x10, 0x1f, 0x00, 0x00, //	1039	afii10145
0xe0, 0x10, 0x08, 0x08, 0x10, 0xe0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, //	1040	afii10017
0xf8, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	1041	afii10018
0xf8, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	1042	afii10019
0xf8, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	1043	afii10020
0x00, 0x00, 0xf8, 0x08, 0xf8, 0x00, 0x00, 0x00, 0x30, 0x1f, 0x10, 0x10, 0x1f, 0x30, 0x00, 0x00, //	1044	afii10021
0xf8, 0x88, 0x88, 0x88, 0x08, 0x08, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, //	1045	afii10022
0x00, 0x78, 0x80, 0xf8, 0x80, 0x78, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, //	1046	afii10024
0x10, 0x08, 0x88, 0x88, 0x50, 0x20, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x09, 0x06, 0x00, 0x00, //	1047	afii10025
0xf8, 0x00, 0x00, 0x80, 0x60, 0xf8, 0x00, 0x00, 0x1f, 0x06, 0x01, 0x00, 0x00, 0x1f, 0x00, 0x00, //	1048	afii10026
0xf2, 0x04, 0x04, 0x84, 0x64, 0xf2, 0x00, 0x00, 0x1f, 0x06, 0x01, 0x00, 0x00, 0x1f, 0x00, 0x00, //	1049	afii10027
0xf8, 0x80, 0x40, 0x20, 0x10, 0x08, 0x00, 0x00, 0x1f, 0x00, 0x01, 0x02, 0x04, 0x18, 0x00, 0x00, //	1050	afii10028
0x00, 0x00, 0xf8, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x08, 0x10, 0x0f, 0x00, 0x00, 0x1f, 0x00, 0x00, //	1051	afii10029
0xf8, 0x30, 0xc0, 0xc0, 0x30, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	1052	afii10030
0xf8, 0x80, 0x80, 0x80, 0x80, 0xf8, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	1053	afii10031
0xf0, 0x08, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	1054	afii10032
0x08, 0xf8, 0x08, 0x08, 0xf8, 0x08, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, //	1055	afii10033
0xf8, 0x08, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, //	1056	afii10034
0xf0, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, //	1057	afii10035
0x00, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, //	1058	afii10036
0xf8, 0x00, 0x00, 0x00, 0x80, 0xf8, 0x00, 0x00, 0x08, 0x11, 0x11, 0x11, 0x08, 0x07, 0x00, 0x00, //	1059	afii10037
0x00, 0xe0, 0x10, 0xf8, 0x10, 0xe0, 0x00, 0x00, 0x00, 0x07, 0x08, 0x1f, 0x08, 0x07, 0x00, 0x00, //	1060	afii10038
0x18, 0x60, 0x80, 0x80, 0x60, 0x18, 0x00, 0x00, 0x18, 0x06, 0x01, 0x01, 0x06, 0x18, 0x00, 0x00, //	1061	afii10039
0xf8, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x1f, 0x70, 0x00, 0x00, //	1062	afii10040
0x78, 0x80, 0x80, 0x80, 0x80, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	1063	afii10041
0x00, 0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x1f, 0x10, 0x1f, 0x00, 0x00, //	1064	afii10042
0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x1f, 0x10, 0x1f, 0x70, 0x00, 0x00, //	1065	afii10043
0x08, 0x08, 0xf8, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x0f, 0x00, 0x00, //	1066	afii10044
0xf8, 0x80, 0x80, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x0f, 0x00, 0x1f, 0x00, 0x00, //	1067	afii10045
0x00, 0xf8, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	1068	afii10046
0x10, 0x08, 0x88, 0x88, 0x90, 0xe0, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x08, 0x07, 0x00, 0x00, //	1069	afii10047
0xf8, 0x80, 0xf0, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x1f, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x00, //	1070	afii10048
0xf0, 0x08, 0x08, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x18, 0x05, 0x03, 0x01, 0x01, 0x1f, 0x00, 0x00, //	1071	afii10049
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	1072	afii10065
0xe0, 0x90, 0x50, 0x50, 0x48, 0x88, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	1073	afii10066
0xc0, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x12, 0x12, 0x0d, 0x00, 0x00, //	1074	afii10067
0x00, 0xc0, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	1075	afii10068
0x00, 0x00, 0xc0, 0x40, 0xc0, 0x00, 0x00, 0x00, 0x30, 0x1e, 0x11, 0x10, 0x1f, 0x30, 0x00, 0x00, //	1076	afii10069
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x0b, 0x00, 0x00, //	1077	afii10070
0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x1d, 0x02, 0x1f, 0x02, 0x1d, 0x00, 0x00, //	1078	afii10072
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x08, 0x10, 0x10, 0x12, 0x12, 0x0d, 0x00, 0x00, //	1079	afii10073
0xc0, 0x00, 0x00, 0x00, 0x80, 0xc0, 0x00, 0x00, 0x1f, 0x04, 0x02, 0x01, 0x00, 0x1f, 0x00, 0x00, //	1080	afii10074
0xc8, 0x10, 0x10, 0x10, 0x90, 0xc8, 0x00, 0x00, 0x1f, 0x04, 0x02, 0x01, 0x00, 0x1f, 0x00, 0x00, //	1081	afii10075
0xc0, 0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x00, 0x1f, 0x04, 0x02, 0x05, 0x08, 0x10, 0x00, 0x00, //	1082	afii10076
0x00, 0x00, 0xc0, 0x40, 0x40, 0xc0, 0x00, 0x00, 0x10, 0x10, 0x0f, 0x00, 0x00, 0x1f, 0x00, 0x00, //	1083	afii10077
0xc0, 0x80, 0x00, 0x00, 0x80, 0xc0, 0x00, 0x00, 0x1f, 0x01, 0x06, 0x06, 0x01, 0x1f, 0x00, 0x00, //	1084	afii10078
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x1f, 0x02, 0x02, 0x02, 0x02, 0x1f, 0x00, 0x00, //	1085	afii10079
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	1086	afii10080
0xc0, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	1087	afii10081
0xc0, 0x80, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x7f, 0x08, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	1088	afii10082
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, //	1089	afii10083
0x00, 0x40, 0x40, 0xc0, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, //	1090	afii10084
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x27, 0x48, 0x48, 0x48, 0x44, 0x3f, 0x00, 0x00, //	1091	afii10085
0x00, 0x80, 0x40, 0xf0, 0x40, 0x80, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x7f, 0x10, 0x0f, 0x00, 0x00, //	1092	afii10086
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x18, 0x05, 0x02, 0x02, 0x05, 0x18, 0x00, 0x00, //	1093	afii10087
0xc0, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x1f, 0x70, 0x00, 0x00, //	1094	afii10088
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x01, 0x02, 0x02, 0x02, 0x02, 0x1f, 0x00, 0x00, //	1095	afii10089
0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x1f, 0x10, 0x1f, 0x00, 0x00, //	1096	afii10090
0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x1f, 0x10, 0x1f, 0x70, 0x00, 0x00, //	1097	afii10091
0x40, 0x40, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x0c, 0x00, 0x00, //	1098	afii10092
0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x0c, 0x00, 0x1f, 0x00, 0x00, //	1099	afii10093
0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, //	1100	afii10094
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x08, 0x10, 0x12, 0x12, 0x12, 0x0f, 0x00, 0x00, //	1101	afii10095
0xc0, 0x00, 0x80, 0x40, 0x40, 0x80, 0x00, 0x00, 0x1f, 0x02, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x00, //	1102	afii10096
0x80, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x00, 0x00, 0x11, 0x0a, 0x06, 0x02, 0x02, 0x1f, 0x00, 0x00, //	1103	afii10097
0xf8, 0x40, 0x80, 0xf8, 0x80, 0x40, 0x80, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x13, 0x14, 0x13, 0x00, //	8470	afii61352
0x80, 0x58, 0x40, 0x40, 0x58, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x0b, 0x00, 0x00, //	1105	afii10071
0x20, 0xf8, 0xa0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x40, 0x40, 0x3f, 0x00, 0x00, //	1106	afii10099
0x00, 0xc0, 0x40, 0x50, 0x48, 0x40, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	1107	afii10100
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x10, 0x08, 0x00, 0x00, //	1108	afii10101
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x08, 0x11, 0x12, 0x12, 0x14, 0x08, 0x00, 0x00, //	1109	afii10102
0x00, 0x00, 0x40, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	1110	afii10103
0x00, 0x00, 0x58, 0xc0, 0x18, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	1111	afii10104
0x00, 0x00, 0x00, 0x00, 0x40, 0xd8, 0x00, 0x00, 0x00, 0x30, 0x40, 0x40, 0x40, 0x3f, 0x00, 0x00, //	1112	afii10105
0x00, 0xc0, 0x40, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0f, 0x00, 0x1f, 0x12, 0x0c, 0x00, 0x00, //	1113	afii10106
0xc0, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x02, 0x02, 0x1f, 0x12, 0x0c, 0x00, 0x00, //	1114	afii10107
0x10, 0x10, 0xf8, 0x50, 0x50, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x00, 0x00, //	1115	afii10108
0xc0, 0x00, 0x10, 0x08, 0x80, 0x40, 0x00, 0x00, 0x1f, 0x04, 0x02, 0x05, 0x08, 0x10, 0x00, 0x00, //	1116	afii10109
0x88, 0x54, 0x24, 0x24, 0x44, 0x88, 0x00, 0x00, 0x08, 0x11, 0x12, 0x12, 0x15, 0x08, 0x00, 0x00, //	167	section
0xc8, 0x10, 0x10, 0x10, 0x10, 0xc8, 0x00, 0x00, 0x27, 0x48, 0x48, 0x48, 0x44, 0x3f, 0x00, 0x00, //	1118	afii10110
0x00, 0xc0, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x30, 0x10, 0x1f, 0x00, 0x00, //	1119	afii10193
#else
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	160	space
0x00, 0x00, 0x00, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, //	161	exclamdown
0x80, 0x40, 0xe0, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x3f, 0x10, 0x10, 0x08, 0x00, 0x00, //	162	cent
0x00, 0x00, 0xe0, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x09, 0x1f, 0x09, 0x09, 0x10, 0x00, 0x00, //	163	sterling
0x20, 0xc0, 0x40, 0x40, 0xc0, 0x20, 0x00, 0x00, 0x04, 0x03, 0x02, 0x02, 0x03, 0x04, 0x00, 0x00, //	164	currency
0x00, 0x88, 0xb0, 0xc0, 0xb0, 0x88, 0x00, 0x00, 0x00, 0x02, 0x02, 0x1f, 0x02, 0x02, 0x00, 0x00, //	165	yen
0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, //	166	brokenbar
0x88, 0x54, 0x24, 0x24, 0x44, 0x88, 0x00, 0x00, 0x08, 0x11, 0x12, 0x12, 0x15, 0x08, 0x00, 0x00, //	167	section
0x00, 0x0c, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	168	dieresis
0xf8, 0xe4, 0x14, 0x14, 0x24, 0xf8, 0x00, 0x00, 0x0f, 0x13, 0x14, 0x14, 0x12, 0x0f, 0x00, 0x00, //	169	copyright
0x00, 0x68, 0x94, 0x94, 0x54, 0xf8, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, //	170	ordfeminine
0x00, 0x00, 0x80, 0x40, 0x80, 0x40, 0x00, 0x00, 0x02, 0x05, 0x0a, 0x15, 0x08, 0x10, 0x00, 0x00, //	171	guillemotleft
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x00, 0x00, //	172	logicalnot
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, //	173	hyphen
0xf8, 0xf4, 0x94, 0x94, 0x64, 0xf8, 0x00, 0x00, 0x0f, 0x17, 0x10, 0x10, 0x17, 0x0f, 0x00, 0x00, //	174	registered
0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	175	macron
0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	176	degree
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x1f, 0x12, 0x12, 0x00, 0x00, //	177	plusminus
0x00, 0x88, 0x44, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, //	178	twosuperior
0x00, 0x88, 0x24, 0x24, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, //	179	threesuperior
0x00, 0x00, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	180	acute
0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x10, 0x08, 0x1f, 0x00, 0x00, //	181	mu
0x00, 0xf0, 0x08, 0xf8, 0x08, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7f, 0x40, 0x7f, 0x00, 0x00, //	182	paragraph
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	183	periodcentered
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x30, 0x00, 0x00, 0x00, 0x00, //	184	cedilla
0x00, 0x00, 0x08, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, //	185	onesuperior
0x00, 0x30, 0x48, 0x48, 0x30, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, //	186	ordmasculine
0x40, 0x80, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x15, 0x0a, 0x05, 0x02, 0x00, 0x00, //	187	guillemotright
0x10, 0xf8, 0x00, 0x80, 0x60, 0x10, 0x00, 0x00, 0x18, 0x04, 0x03, 0x0c, 0x0a, 0x1f, 0x00, 0x00, //	188	onequarter
0x10, 0xf8, 0x00, 0x80, 0x60, 0x10, 0x00, 0x00, 0x18, 0x04, 0x03, 0x12, 0x19, 0x16, 0x00, 0x00, //	189	onehalf
0x88, 0xa8, 0x50, 0xc0, 0x20, 0x18, 0x00, 0x00, 0x08, 0x06, 0x01, 0x0c, 0x0a, 0x1f, 0x00, 0x00, //	190	threequarters
0x00, 0x00, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x47, 0x40, 0x40, 0x30, 0x00, 0x00, //	191	questiondown
0xc0, 0x20, 0x12, 0x14, 0x20, 0xc0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, //	192	Agrave
0xc0, 0x20, 0x14, 0x12, 0x20, 0xc0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, //	193	Aacute
0xc0, 0x24, 0x12, 0x12, 0x24, 0xc0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, //	194	Acircumflex
0xc4, 0x22, 0x12, 0x14, 0x24, 0xc2, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, //	195	Atilde
0xc0, 0x24, 0x10, 0x10, 0x24, 0xc0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, //	196	Adieresis
0xc0, 0x28, 0x14, 0x14, 0x28, 0xc0, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, //	197	Aring
0xe0, 0x90, 0x88, 0xf8, 0x88, 0x88, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x00, 0x00, //	198	AE
0xf0, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x0f, 0x10, 0x50, 0x30, 0x10, 0x0c, 0x00, 0x00, //	199	Ccedilla
0xf0, 0x10, 0x12, 0x14, 0x10, 0x10, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, //	200	Egrave
0xf0, 0x10, 0x14, 0x12, 0x10, 0x10, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, //	201	Eacute
0xf0, 0x14, 0x12, 0x12, 0x14, 0x10, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, //	202	Ecircumflex
0xf0, 0x14, 0x10, 0x10, 0x14, 0x10, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, //	203	Edieresis
0x00, 0x10, 0x12, 0xf4, 0x10, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	204	Igrave
0x00, 0x10, 0x10, 0xf4, 0x12, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	205	Iacute
0x00, 0x10, 0x14, 0xf2, 0x14, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	206	Icircumflex
0x00, 0x10, 0x14, 0xf0, 0x14, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	207	Idieresis
#ifdef ISO_8859_9
0xe0, 0x12, 0x14, 0x14, 0x14, 0x22, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x11, 0x09, 0x1f, 0x00, 0x00, //	286	Gbreve
#else
0x80, 0xf8, 0x88, 0x88, 0x08, 0x10, 0xe0, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x08, 0x07, 0x00, //	208	Eth
#endif
0xf4, 0x32, 0xc2, 0x04, 0x04, 0xf2, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x07, 0x18, 0x1f, 0x00, 0x00, //	209	Ntilde
0xe0, 0x10, 0x12, 0x14, 0x10, 0xe0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	210	Ograve
0xe0, 0x10, 0x14, 0x12, 0x10, 0xe0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	211	Oacute
0xe0, 0x14, 0x12, 0x12, 0x14, 0xe0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	212	Ocircumflex
0xe4, 0x12, 0x12, 0x14, 0x14, 0xe2, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	213	Otilde
0xe0, 0x14, 0x10, 0x10, 0x14, 0xe0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	214	Odieresis
0x40, 0x80, 0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x10, 0x08, 0x05, 0x02, 0x05, 0x08, 0x10, 0x00, //	215	multiply
0xf0, 0x08, 0x08, 0xe8, 0x18, 0xf6, 0x00, 0x00, 0x6f, 0x18, 0x17, 0x10, 0x10, 0x0f, 0x00, 0x00, //	216	Oslash
0xf0, 0x00, 0x02, 0x04, 0x00, 0xf0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	217	Ugrave
0xf0, 0x00, 0x04, 0x02, 0x00, 0xf0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	218	Uacute
0xf0, 0x04, 0x02, 0x02, 0x04, 0xf0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	219	Ucircumflex
0xf0, 0x04, 0x00, 0x00, 0x04, 0xf0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	220	Udieresis
#ifdef ISO_8859_9
0x00, 0x10, 0x10, 0xf6, 0x10, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	304	Idotaccent
0x70, 0x88, 0x88, 0x08, 0x08, 0x30, 0x00, 0x00, 0x0c, 0x10, 0x50, 0x31, 0x11, 0x0e, 0x00, 0x00, //	350	Scedilla
#else
0x00, 0x30, 0xc0, 0x04, 0xc2, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, //	221	Yacute
0xf8, 0x20, 0x20, 0x20, 0x20, 0xc0, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00, 0x00, //	222	Thorn
#endif
0x00, 0xf0, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x10, 0x1f, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00, //	223	germandbls
0x80, 0x40, 0x48, 0x50, 0x40, 0x80, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	224	agrave
0x80, 0x40, 0x40, 0x50, 0x48, 0x80, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	225	aacute
0x80, 0x50, 0x48, 0x48, 0x50, 0x80, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	226	acircumflex
0x90, 0x48, 0x48, 0x50, 0x50, 0x88, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	227	atilde
0x80, 0x50, 0x40, 0x40, 0x50, 0x80, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	228	adieresis
0x80, 0x48, 0x54, 0x54, 0x48, 0x80, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x1f, 0x00, 0x00, //	229	aring
0x80, 0x40, 0x40, 0xc0, 0x40, 0x40, 0x80, 0x00, 0x0c, 0x12, 0x11, 0x1f, 0x12, 0x12, 0x0b, 0x00, //	230	ae
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x50, 0x30, 0x10, 0x08, 0x00, 0x00, //	231	ccedilla
0x80, 0x40, 0x48, 0x50, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x0b, 0x00, 0x00, //	232	egrave
0x80, 0x40, 0x50, 0x48, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x0b, 0x00, 0x00, //	233	eacute
0x80, 0x50, 0x48, 0x48, 0x50, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x0b, 0x00, 0x00, //	234	ecircumflex
0x80, 0x50, 0x40, 0x40, 0x50, 0x80, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x0b, 0x00, 0x00, //	235	edieresis
0x00, 0x00, 0x48, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	236	igrave
0x00, 0x00, 0x40, 0xd0, 0x08, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	237	iacute
0x00, 0x10, 0x48, 0xc8, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	238	icircumflex
0x00, 0x00, 0x50, 0xc0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	239	idieresis
#ifdef ISO_8859_9
0x80, 0x48, 0x50, 0x50, 0x90, 0x48, 0x00, 0x00, 0x33, 0x4c, 0x54, 0x54, 0x53, 0x20, 0x00, 0x00, //	287	gbreve
#else
0x00, 0x80, 0x54, 0x48, 0x54, 0xe0, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	240	eth
#endif
0xd0, 0x88, 0x48, 0x50, 0x50, 0x88, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, //	241	ntilde
0x80, 0x40, 0x48, 0x50, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	242	ograve
0x80, 0x40, 0x50, 0x48, 0x40, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	243	oacute
0x80, 0x50, 0x48, 0x48, 0x50, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	244	ocircumflex
0x90, 0x48, 0x48, 0x50, 0x50, 0x88, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	245	otilde
0x80, 0x50, 0x40, 0x40, 0x50, 0x80, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	246	odieresis
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x15, 0x15, 0x04, 0x04, 0x00, 0x00, //	247	divide
0x80, 0x40, 0x40, 0xc0, 0x60, 0x90, 0x00, 0x00, 0x6f, 0x18, 0x16, 0x11, 0x10, 0x0f, 0x00, 0x00, //	248	oslash
0xc0, 0x00, 0x08, 0x10, 0x00, 0xc0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x1f, 0x00, 0x00, //	249	ugrave
0xc0, 0x00, 0x10, 0x08, 0x00, 0xc0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x1f, 0x00, 0x00, //	250	uacute
0xc0, 0x10, 0x08, 0x08, 0x10, 0xc0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x1f, 0x00, 0x00, //	251	ucircumflex
0xc0, 0x10, 0x00, 0x00, 0x10, 0xc0, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x08, 0x1f, 0x00, 0x00, //	252	udieresis
#ifdef ISO_8859_9
0x00, 0x00, 0x40, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, //	305	dotlessi
0x80, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x08, 0x11, 0x52, 0x32, 0x14, 0x08, 0x00, 0x00, //	351	scedilla
#else
0xc0, 0x00, 0x10, 0x08, 0x00, 0xc0, 0x00, 0x00, 0x20, 0x43, 0x4c, 0x38, 0x0e, 0x01, 0x00, 0x00, //	253	yacute
0xf8, 0x80, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x7f, 0x08, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, //	254	thorn
#endif	// ISO_8859_9
0xc0, 0x10, 0x00, 0x00, 0x10, 0xc0, 0x00, 0x00, 0x20, 0x43, 0x4c, 0x38, 0x0e, 0x01, 0x00, 0x00, //	255	ydieresis
#endif	// ISO_8859_2
#else
#ifdef CP1251
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	160	NO-BREAK SPACE
0x00, 0x0a, 0x0a, 0x0a, 0x04, 0x04, 0x08, 0x00, //	161	CYRILLIC CAPITAL LETTER SHORT U
0x00, 0x12, 0x0c, 0x00, 0x12, 0x0a, 0x04, 0x08, //	162	CYRILLIC SMALL LETTER SHORT U
0x00, 0x02, 0x02, 0x02, 0x02, 0x12, 0x0c, 0x00, //	163	CYRILLIC CAPITAL LETTER JE
0x00, 0x00, 0x11, 0x0e, 0x0a, 0x0e, 0x11, 0x00, //	164	CURRENCY SIGN
0x00, 0x02, 0x1e, 0x10, 0x10, 0x10, 0x10, 0x00, //	165	CYRILLIC CAPITAL LETTER GHE WITH UPTURN
0x04, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, //	166	BROKEN BAR
0x0e, 0x10, 0x1c, 0x12, 0x0e, 0x02, 0x1c, 0x00, //	167	SECTION SIGN
0x00, 0x1e, 0x10, 0x1c, 0x10, 0x10, 0x1e, 0x00, //	168	CYRILLIC CAPITAL LETTER IO
0x00, 0x0e, 0x15, 0x19, 0x19, 0x15, 0x0e, 0x00, //	169	COPYRIGHT SIGN
0x00, 0x0c, 0x12, 0x18, 0x10, 0x12, 0x0c, 0x00, //	170	CYRILLIC CAPITAL LETTER UKRAINIAN IE
0x00, 0x00, 0x00, 0x0a, 0x14, 0x0a, 0x00, 0x00, //	171	LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
0x00, 0x00, 0x00, 0x00, 0x0e, 0x02, 0x02, 0x00, //	172	NOT SIGN
0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, //	173	SOFT HYPHEN
0x00, 0x0e, 0x1d, 0x1b, 0x1d, 0x1b, 0x0e, 0x00, //	174	REGISTERED SIGN
0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, //	175	CYRILLIC CAPITAL LETTER YI
0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, //	176	DEGREE SIGN
0x00, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x0e, 0x00, //	177	PLUS-MINUS SIGN
0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, //	178	CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
0x00, 0x04, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00, //	179	CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
0x00, 0x00, 0x02, 0x1e, 0x10, 0x10, 0x10, 0x00, //	180	CYRILLIC SMALL LETTER GHE WITH UPTURN
0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x1c, 0x10, //	181	MICRO SIGN
0x00, 0x0f, 0x1d, 0x1d, 0x0d, 0x05, 0x05, 0x00, //	182	PILCROW SIGN
0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, //	183	MIDDLE DOT
0x00, 0x14, 0x00, 0x0c, 0x16, 0x18, 0x0c, 0x00, //	184	CYRILLIC SMALL LETTER IO
0x00, 0x18, 0x16, 0x15, 0x16, 0x14, 0x17, 0x00, //	185	NUMERO SIGN
0x00, 0x00, 0x00, 0x06, 0x0c, 0x08, 0x06, 0x00, //	186	CYRILLIC SMALL LETTER UKRAINIAN IE
0x00, 0x00, 0x00, 0x14, 0x0a, 0x14, 0x00, 0x00, //	187	RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
0x00, 0x02, 0x00, 0x02, 0x02, 0x02, 0x0a, 0x04, //	188	CYRILLIC SMALL LETTER JE
0x00, 0x0c, 0x12, 0x08, 0x04, 0x12, 0x0c, 0x00, //	189	CYRILLIC CAPITAL LETTER DZE
0x00, 0x00, 0x00, 0x0e, 0x18, 0x06, 0x1c, 0x00, //	190	CYRILLIC SMALL LETTER DZE
0x00, 0x0a, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00, //	191	CYRILLIC SMALL LETTER YI
0x00, 0x0c, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x00, //	192	CYRILLIC CAPITAL LETTER A
0x00, 0x1c, 0x10, 0x1c, 0x12, 0x12, 0x1c, 0x00, //	193	CYRILLIC CAPITAL LETTER BE
0x00, 0x1c, 0x12, 0x1c, 0x12, 0x12, 0x1c, 0x00, //	194	CYRILLIC CAPITAL LETTER VE
0x00, 0x1e, 0x12, 0x10, 0x10, 0x10, 0x10, 0x00, //	195	CYRILLIC CAPITAL LETTER GHE
0x00, 0x0c, 0x14, 0x14, 0x14, 0x14, 0x1e, 0x12, //	196	CYRILLIC CAPITAL LETTER DE
0x00, 0x1e, 0x10, 0x1c, 0x10, 0x10, 0x1e, 0x00, //	197	CYRILLIC CAPITAL LETTER IE
0x00, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x15, 0x00, //	198	CYRILLIC CAPITAL LETTER ZHE
0x00, 0x0c, 0x12, 0x04, 0x02, 0x12, 0x0c, 0x00, //	199	CYRILLIC CAPITAL LETTER ZE
0x00, 0x12, 0x12, 0x16, 0x1a, 0x12, 0x12, 0x00, //	200	CYRILLIC CAPITAL LETTER I
0x12, 0x0c, 0x12, 0x16, 0x1a, 0x12, 0x12, 0x00, //	201	CYRILLIC CAPITAL LETTER SHORT I
0x00, 0x12, 0x14, 0x18, 0x14, 0x12, 0x12, 0x00, //	202	CYRILLIC CAPITAL LETTER KA
0x00, 0x06, 0x0a, 0x0a, 0x0a, 0x0a, 0x12, 0x00, //	203	CYRILLIC CAPITAL LETTER EL
0x00, 0x12, 0x1e, 0x1e, 0x12, 0x12, 0x12, 0x00, //	204	CYRILLIC CAPITAL LETTER EM
0x00, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, //	205	CYRILLIC CAPITAL LETTER EN
0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, //	206	CYRILLIC CAPITAL LETTER O
0x00, 0x1e, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, //	207	CYRILLIC CAPITAL LETTER PE
0x00, 0x1c, 0x12, 0x12, 0x1c, 0x10, 0x10, 0x00, //	208	CYRILLIC CAPITAL LETTER ER
0x00, 0x0c, 0x12, 0x10, 0x10, 0x12, 0x0c, 0x00, //	209	CYRILLIC CAPITAL LETTER ES
0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, //	210	CYRILLIC CAPITAL LETTER TE
0x00, 0x12, 0x12, 0x12, 0x0e, 0x02, 0x1c, 0x00, //	211	CYRILLIC CAPITAL LETTER U
0x00, 0x04, 0x0e, 0x15, 0x15, 0x0e, 0x04, 0x00, //	212	CYRILLIC CAPITAL LETTER EF
0x00, 0x0a, 0x0a, 0x04, 0x04, 0x0a, 0x0a, 0x00, //	213	CYRILLIC CAPITAL LETTER HA
0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1e, 0x02, //	214	CYRILLIC CAPITAL LETTER TSE
0x00, 0x0a, 0x0a, 0x0a, 0x06, 0x02, 0x02, 0x00, //	215	CYRILLIC CAPITAL LETTER CHE
0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x00, //	216	CYRILLIC CAPITAL LETTER SHA
0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x01, //	217	CYRILLIC CAPITAL LETTER SHCHA
0x00, 0x1c, 0x04, 0x06, 0x05, 0x05, 0x06, 0x00, //	218	CYRILLIC CAPITAL LETTER HARD SIGN
0x00, 0x11, 0x11, 0x19, 0x15, 0x15, 0x19, 0x00, //	219	CYRILLIC CAPITAL LETTER YERU
0x00, 0x08, 0x08, 0x0c, 0x0a, 0x0a, 0x0c, 0x00, //	220	CYRILLIC CAPITAL LETTER SOFT SIGN
0x00, 0x1c, 0x02, 0x0e, 0x02, 0x02, 0x1c, 0x00, //	221	CYRILLIC CAPITAL LETTER E
0x00, 0x12, 0x15, 0x1d, 0x15, 0x15, 0x12, 0x00, //	222	CYRILLIC CAPITAL LETTER YU
0x00, 0x0e, 0x12, 0x12, 0x0e, 0x12, 0x12, 0x00, //	223	CYRILLIC CAPITAL LETTER YA
0x00, 0x00, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	224	CYRILLIC SMALL LETTER A
0x00, 0x0c, 0x10, 0x1c, 0x12, 0x12, 0x0c, 0x00, //	225	CYRILLIC SMALL LETTER BE
0x00, 0x00, 0x00, 0x1c, 0x1c, 0x12, 0x1c, 0x00, //	226	CYRILLIC SMALL LETTER VE
0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x00, //	227	CYRILLIC SMALL LETTER GHE
0x00, 0x00, 0x00, 0x0e, 0x0a, 0x12, 0x1e, 0x12, //	228	CYRILLIC SMALL LETTER DE
0x00, 0x00, 0x00, 0x0c, 0x16, 0x18, 0x0c, 0x00, //	229	CYRILLIC SMALL LETTER IE
0x00, 0x00, 0x00, 0x15, 0x0e, 0x15, 0x15, 0x00, //	230	CYRILLIC SMALL LETTER ZHE
0x00, 0x00, 0x00, 0x0e, 0x06, 0x02, 0x0c, 0x00, //	231	CYRILLIC SMALL LETTER ZE
0x00, 0x00, 0x00, 0x12, 0x16, 0x1a, 0x12, 0x00, //	232	CYRILLIC SMALL LETTER I
0x00, 0x12, 0x0c, 0x12, 0x16, 0x1a, 0x12, 0x00, //	233	CYRILLIC SMALL LETTER SHORT I
0x00, 0x00, 0x00, 0x12, 0x1c, 0x14, 0x12, 0x00, //	234	CYRILLIC SMALL LETTER KA
0x00, 0x00, 0x00, 0x06, 0x0a, 0x0a, 0x12, 0x00, //	235	CYRILLIC SMALL LETTER EL
0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x15, 0x00, //	236	CYRILLIC SMALL LETTER EM
0x00, 0x00, 0x00, 0x12, 0x1e, 0x12, 0x12, 0x00, //	237	CYRILLIC SMALL LETTER EN
0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, //	238	CYRILLIC SMALL LETTER O
0x00, 0x00, 0x00, 0x1e, 0x12, 0x12, 0x12, 0x00, //	239	CYRILLIC SMALL LETTER PE
0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x1c, 0x10, //	240	CYRILLIC SMALL LETTER ER
0x00, 0x00, 0x00, 0x06, 0x08, 0x08, 0x06, 0x00, //	241	CYRILLIC SMALL LETTER ES
0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x00, //	242	CYRILLIC SMALL LETTER TE
0x00, 0x00, 0x00, 0x12, 0x12, 0x0a, 0x04, 0x08, //	243	CYRILLIC SMALL LETTER U
0x00, 0x0c, 0x04, 0x04, 0x0e, 0x0a, 0x0e, 0x04, //	244	CYRILLIC SMALL LETTER EF
0x00, 0x00, 0x00, 0x12, 0x0c, 0x0c, 0x12, 0x00, //	245	CYRILLIC SMALL LETTER HA
0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x1e, 0x02, //	246	CYRILLIC SMALL LETTER TSE
0x00, 0x00, 0x00, 0x12, 0x12, 0x0e, 0x02, 0x00, //	247	CYRILLIC SMALL LETTER CHE
0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x1f, 0x00, //	248	CYRILLIC SMALL LETTER SHA
0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x1f, 0x01, //	249	CYRILLIC SMALL LETTER SHCHA
0x00, 0x00, 0x00, 0x18, 0x0c, 0x0a, 0x0c, 0x00, //	250	CYRILLIC SMALL LETTER HARD SIGN
0x00, 0x00, 0x00, 0x12, 0x1a, 0x16, 0x1a, 0x00, //	251	CYRILLIC SMALL LETTER YERU
0x00, 0x00, 0x00, 0x10, 0x1c, 0x12, 0x1c, 0x00, //	252	CYRILLIC SMALL LETTER SOFT SIGN
0x00, 0x00, 0x00, 0x0c, 0x06, 0x02, 0x0c, 0x00, //	253	CYRILLIC SMALL LETTER E
0x00, 0x00, 0x00, 0x14, 0x1a, 0x1a, 0x14, 0x00, //	254	CYRILLIC SMALL LETTER YU
0x00, 0x00, 0x00, 0x06, 0x0a, 0x06, 0x0a, 0x00, //	255	CYRILLIC SMALL LETTER YA
#elif defined ISO_8859_2
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	160	space
0x00, 0x0c, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x06, //	260	Aogonek
0x11, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	728	breve
0x00, 0x08, 0x0c, 0x18, 0x08, 0x08, 0x0f, 0x00, //	321	Lslash
0x00, 0x00, 0x11, 0x0e, 0x0a, 0x0e, 0x11, 0x00, //	164	currency
0x0a, 0x04, 0x10, 0x10, 0x10, 0x10, 0x1e, 0x00, //	317	Lcaron
0x04, 0x08, 0x0e, 0x10, 0x0c, 0x02, 0x1c, 0x00, //	346	Sacute
0x0e, 0x10, 0x1c, 0x12, 0x0e, 0x02, 0x1c, 0x00, //	167	section
0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	168	dieresis
0x12, 0x0c, 0x0e, 0x10, 0x0c, 0x02, 0x1c, 0x00, //	352	Scaron
//0x00, 0x0c, 0x12, 0x08, 0x04, 0x12, 0x0c, 0x04, //	350	Scedilla
0x0e, 0x11, 0x10, 0x0e, 0x01, 0x11, 0x0e, 0x04, // 	170/350 Scedilla (alex)
0x0a, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x00, //	356	Tcaron
0x04, 0x08, 0x1e, 0x04, 0x08, 0x10, 0x1e, 0x00, //	377	Zacute
0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, //	173	hyphen
0x12, 0x0c, 0x1e, 0x04, 0x08, 0x10, 0x1e, 0x00, //	381	Zcaron
0x0c, 0x00, 0x1e, 0x04, 0x08, 0x10, 0x1e, 0x00, //	379	Zdotaccent
0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, //	176	degree
0x00, 0x00, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x04, //	261	aogonek
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, //	731	ogonek
0x00, 0x0c, 0x04, 0x06, 0x0c, 0x04, 0x0e, 0x00, //	322	lslash
0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, //	180	acute
0x0a, 0x04, 0x0c, 0x04, 0x04, 0x04, 0x0e, 0x00, //	318	lcaron
0x02, 0x04, 0x00, 0x06, 0x0c, 0x02, 0x0c, 0x00, //	347	sacute
0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	711	caron
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, //	184	cedilla
0x0a, 0x04, 0x00, 0x06, 0x0c, 0x02, 0x0c, 0x00, //	353	scaron
//0x00, 0x00, 0x00, 0x06, 0x0c, 0x02, 0x0c, 0x04, //	351	scedilla
0x00, 0x00, 0x0e, 0x10, 0x0e, 0x01, 0x1E, 0x04, // 	186/351 scedilla (alex)
0x14, 0x08, 0x08, 0x1c, 0x08, 0x0a, 0x04, 0x00, //	357	tcaron
0x04, 0x08, 0x00, 0x1e, 0x04, 0x08, 0x1e, 0x00, //	378	zacute
0x09, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	733	hungarumlaut
0x12, 0x0c, 0x00, 0x1e, 0x04, 0x08, 0x1e, 0x00, //	382	zcaron
0x00, 0x0c, 0x00, 0x1e, 0x04, 0x08, 0x1e, 0x00, //	380	zdotaccent
0x04, 0x08, 0x1c, 0x12, 0x1c, 0x12, 0x12, 0x00, //	340	Racute
0x04, 0x08, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, //	193	Aacute
//0x0c, 0x12, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, //	194	Acircumflex
//0x12, 0x0c, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, //	258	Abreve
0x0e, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x11, 0x00, //  	194	Acircumflex (alex)
0x0e, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x11, 0x00, //  	195/258	Abreve (alex)
0x12, 0x00, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, //	196	Adieresis
0x02, 0x04, 0x10, 0x10, 0x10, 0x10, 0x1e, 0x00, //	313	Lacute
0x04, 0x08, 0x0c, 0x12, 0x10, 0x12, 0x0c, 0x00, //	262	Cacute
0x00, 0x0c, 0x12, 0x10, 0x10, 0x12, 0x0c, 0x08, //	199	Ccedilla
0x12, 0x0c, 0x0c, 0x12, 0x10, 0x12, 0x0c, 0x00, //	268	Ccaron
0x04, 0x08, 0x1e, 0x10, 0x1c, 0x10, 0x1e, 0x00, //	201	Eacute
0x00, 0x1e, 0x10, 0x1c, 0x10, 0x10, 0x1e, 0x04, //	280	Eogonek
0x12, 0x00, 0x1e, 0x10, 0x1c, 0x10, 0x1e, 0x00, //	203	Edieresis
0x12, 0x0c, 0x1e, 0x10, 0x1c, 0x10, 0x1e, 0x00, //	282	Ecaron
0x02, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x00, //	205	Iacute
//0x04, 0x0a, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x00, //	206	Icircumflex
0x04, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, // 	206	Icircumflex (alex)
0x12, 0x0c, 0x1c, 0x12, 0x12, 0x12, 0x1c, 0x00, //	270	Dcaron
0x00, 0x0e, 0x09, 0x1d, 0x09, 0x09, 0x0e, 0x00, //	272	Dcroat
0x04, 0x08, 0x12, 0x1a, 0x16, 0x12, 0x12, 0x00, //	323	Nacute
0x12, 0x0c, 0x12, 0x1a, 0x16, 0x12, 0x12, 0x00, //	327	Ncaron
0x04, 0x08, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, //	211	Oacute
0x0c, 0x12, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, //	212	Ocircumflex
0x09, 0x12, 0x06, 0x09, 0x09, 0x09, 0x06, 0x00, //	336	Ohungarumlaut
0x12, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, //	214	Odieresis
0x00, 0x00, 0x00, 0x00, 0x0a, 0x04, 0x0a, 0x00, //	215	multiply
0x12, 0x0c, 0x1c, 0x12, 0x1c, 0x12, 0x12, 0x00, //	344	Rcaron
0x04, 0x0a, 0x04, 0x12, 0x12, 0x12, 0x0c, 0x00, //	366	Uring
0x04, 0x08, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, //	218	Uacute
0x09, 0x12, 0x00, 0x09, 0x09, 0x09, 0x06, 0x00, //	368	Uhungarumlaut
0x12, 0x00, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, //	220	Udieresis
0x02, 0x04, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, //	221	Yacute
//0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, //	354	Tcommaaccent
0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04, // 	222/354	Tcommaaccent (alex)
0x00, 0x0c, 0x12, 0x14, 0x14, 0x12, 0x14, 0x00, //	223	germandbls
0x04, 0x08, 0x00, 0x14, 0x1a, 0x10, 0x10, 0x00, //	341	racute
0x04, 0x08, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	225	aacute
//0x04, 0x0a, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	226	acircumflex
//0x12, 0x0c, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	259	abreve
0x0e, 0x00, 0x0e, 0x01, 0x0f, 0x11, 0x0f, 0x00, // 	226	acircumflex (alex)
0x0e, 0x00, 0x0e, 0x01, 0x0f, 0x11, 0x0f, 0x00, // 	227/259	abreve (alex)
0x00, 0x0a, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	228	adieresis
0x02, 0x04, 0x0c, 0x04, 0x04, 0x04, 0x0e, 0x00, //	314	lacute
0x02, 0x04, 0x00, 0x06, 0x08, 0x08, 0x06, 0x00, //	263	cacute
0x00, 0x00, 0x00, 0x06, 0x08, 0x08, 0x06, 0x04, //	231	ccedilla
0x12, 0x0c, 0x00, 0x0c, 0x10, 0x10, 0x0c, 0x00, //	269	ccaron
0x04, 0x08, 0x00, 0x0c, 0x16, 0x18, 0x0c, 0x00, //	233	eacute
0x00, 0x00, 0x00, 0x0c, 0x16, 0x18, 0x0c, 0x04, //	281	eogonek
0x00, 0x0a, 0x00, 0x0c, 0x16, 0x18, 0x0c, 0x00, //	235	edieresis
0x12, 0x0c, 0x00, 0x0c, 0x16, 0x18, 0x0c, 0x00, //	283	ecaron
0x02, 0x04, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00, //	237	iacute
//0x04, 0x0a, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00, //	238	icircumflex
0x04, 0x0a, 0x00, 0x04, 0x04, 0x04, 0x0e, 0x00, // 	238     icircumflex (alex)
0x14, 0x0a, 0x02, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	271	dcaron
0x00, 0x04, 0x0e, 0x04, 0x0c, 0x14, 0x0c, 0x00, //	273	dcroat
0x04, 0x08, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x00, //	324	nacute
0x12, 0x0c, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x00, //	328	ncaron
0x04, 0x08, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, //	243	oacute
0x0c, 0x12, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, //	244	ocircumflex
0x09, 0x12, 0x00, 0x06, 0x09, 0x09, 0x06, 0x00, //	337	ohungarumlaut
0x00, 0x12, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, //	246	odieresis
0x00, 0x00, 0x04, 0x00, 0x0e, 0x00, 0x04, 0x00, //	247	divide
0x12, 0x0c, 0x00, 0x14, 0x1a, 0x10, 0x10, 0x00, //	345	rcaron
0x04, 0x0a, 0x04, 0x12, 0x12, 0x12, 0x0e, 0x00, //	367	uring
0x04, 0x08, 0x00, 0x12, 0x12, 0x12, 0x0e, 0x00, //	250	uacute
0x09, 0x12, 0x00, 0x09, 0x09, 0x09, 0x07, 0x00, //	369	uhungarumlaut
0x00, 0x12, 0x00, 0x12, 0x12, 0x12, 0x0e, 0x00, //	252	udieresis
0x04, 0x08, 0x00, 0x12, 0x12, 0x0e, 0x12, 0x0c, //	253	yacute
//0x00, 0x08, 0x08, 0x1c, 0x08, 0x0a, 0x04, 0x08, //	355	tcommaaccent
0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x03, 0x02, // 	254/355	tcommaaccent (alex)
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	729	dotaccent
#elif defined ISO_8859_5
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	160	space
0x00, 0x1e, 0x10, 0x1c, 0x10, 0x10, 0x1e, 0x00, //	1025	afii10023
0x00, 0x1c, 0x08, 0x0c, 0x0a, 0x0a, 0x02, 0x04, //	1026	afii10051
0x00, 0x1e, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, //	1027	afii10052
0x00, 0x0c, 0x12, 0x18, 0x10, 0x12, 0x0c, 0x00, //	1028	afii10053
0x00, 0x0c, 0x12, 0x08, 0x04, 0x12, 0x0c, 0x00, //	1029	afii10054
0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, //	1030	afii10055
0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, //	1031	afii10056
0x00, 0x02, 0x02, 0x02, 0x02, 0x12, 0x0c, 0x00, //	1032	afii10057
0x00, 0x0c, 0x14, 0x16, 0x15, 0x15, 0x16, 0x00, //	1033	afii10058
0x00, 0x14, 0x14, 0x1e, 0x15, 0x15, 0x16, 0x00, //	1034	afii10059
0x00, 0x1c, 0x08, 0x0c, 0x0a, 0x0a, 0x0a, 0x00, //	1035	afii10060
0x00, 0x12, 0x14, 0x18, 0x18, 0x14, 0x12, 0x00, //	1036	afii10061
0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, //	173	hyphen
0x00, 0x0a, 0x0a, 0x0a, 0x04, 0x04, 0x08, 0x00, //	1038	afii10062
0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0e, 0x04, //	1039	afii10145
0x00, 0x0c, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x00, //	1040	afii10017
0x00, 0x1c, 0x10, 0x1c, 0x12, 0x12, 0x1c, 0x00, //	1041	afii10018
0x00, 0x1c, 0x12, 0x1c, 0x12, 0x12, 0x1c, 0x00, //	1042	afii10019
0x00, 0x1e, 0x12, 0x10, 0x10, 0x10, 0x10, 0x00, //	1043	afii10020
0x00, 0x0c, 0x14, 0x14, 0x14, 0x14, 0x1e, 0x12, //	1044	afii10021
0x00, 0x1e, 0x10, 0x1c, 0x10, 0x10, 0x1e, 0x00, //	1045	afii10022
0x00, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x15, 0x00, //	1046	afii10024
0x00, 0x0c, 0x12, 0x04, 0x02, 0x12, 0x0c, 0x00, //	1047	afii10025
0x00, 0x12, 0x12, 0x16, 0x1a, 0x12, 0x12, 0x00, //	1048	afii10026
0x12, 0x0c, 0x12, 0x16, 0x1a, 0x12, 0x12, 0x00, //	1049	afii10027
0x00, 0x12, 0x14, 0x18, 0x14, 0x12, 0x12, 0x00, //	1050	afii10028
0x00, 0x06, 0x0a, 0x0a, 0x0a, 0x0a, 0x12, 0x00, //	1051	afii10029
0x00, 0x12, 0x1e, 0x1e, 0x12, 0x12, 0x12, 0x00, //	1052	afii10030
0x00, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, //	1053	afii10031
0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, //	1054	afii10032
0x00, 0x1e, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, //	1055	afii10033
0x00, 0x1c, 0x12, 0x12, 0x1c, 0x10, 0x10, 0x00, //	1056	afii10034
0x00, 0x0c, 0x12, 0x10, 0x10, 0x12, 0x0c, 0x00, //	1057	afii10035
0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, //	1058	afii10036
0x00, 0x12, 0x12, 0x12, 0x0e, 0x02, 0x1c, 0x00, //	1059	afii10037
0x00, 0x04, 0x0e, 0x15, 0x15, 0x0e, 0x04, 0x00, //	1060	afii10038
0x00, 0x0a, 0x0a, 0x04, 0x04, 0x0a, 0x0a, 0x00, //	1061	afii10039
0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1e, 0x02, //	1062	afii10040
0x00, 0x0a, 0x0a, 0x0a, 0x06, 0x02, 0x02, 0x00, //	1063	afii10041
0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x00, //	1064	afii10042
0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x01, //	1065	afii10043
0x00, 0x1c, 0x04, 0x06, 0x05, 0x05, 0x06, 0x00, //	1066	afii10044
0x00, 0x11, 0x11, 0x19, 0x15, 0x15, 0x19, 0x00, //	1067	afii10045
0x00, 0x08, 0x08, 0x0c, 0x0a, 0x0a, 0x0c, 0x00, //	1068	afii10046
0x00, 0x1c, 0x02, 0x0e, 0x02, 0x02, 0x1c, 0x00, //	1069	afii10047
0x00, 0x12, 0x15, 0x1d, 0x15, 0x15, 0x12, 0x00, //	1070	afii10048
0x00, 0x0e, 0x12, 0x12, 0x0e, 0x12, 0x12, 0x00, //	1071	afii10049
0x00, 0x00, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	1072	afii10065
0x00, 0x0c, 0x10, 0x1c, 0x12, 0x12, 0x0c, 0x00, //	1073	afii10066
0x00, 0x00, 0x00, 0x1c, 0x1c, 0x12, 0x1c, 0x00, //	1074	afii10067
0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x00, //	1075	afii10068
0x00, 0x00, 0x00, 0x0e, 0x0a, 0x12, 0x1e, 0x12, //	1076	afii10069
0x00, 0x00, 0x00, 0x0c, 0x16, 0x18, 0x0c, 0x00, //	1077	afii10070
0x00, 0x00, 0x00, 0x15, 0x0e, 0x15, 0x15, 0x00, //	1078	afii10072
0x00, 0x00, 0x00, 0x0e, 0x06, 0x02, 0x0c, 0x00, //	1079	afii10073
0x00, 0x00, 0x00, 0x12, 0x16, 0x1a, 0x12, 0x00, //	1080	afii10074
0x00, 0x12, 0x0c, 0x12, 0x16, 0x1a, 0x12, 0x00, //	1081	afii10075
0x00, 0x00, 0x00, 0x12, 0x1c, 0x14, 0x12, 0x00, //	1082	afii10076
0x00, 0x00, 0x00, 0x06, 0x0a, 0x0a, 0x12, 0x00, //	1083	afii10077
0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x15, 0x00, //	1084	afii10078
0x00, 0x00, 0x00, 0x12, 0x1e, 0x12, 0x12, 0x00, //	1085	afii10079
0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, //	1086	afii10080
0x00, 0x00, 0x00, 0x1e, 0x12, 0x12, 0x12, 0x00, //	1087	afii10081
0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x1c, 0x10, //	1088	afii10082
0x00, 0x00, 0x00, 0x06, 0x08, 0x08, 0x06, 0x00, //	1089	afii10083
0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x00, //	1090	afii10084
0x00, 0x00, 0x00, 0x12, 0x12, 0x0a, 0x04, 0x08, //	1091	afii10085
0x00, 0x0c, 0x04, 0x04, 0x0e, 0x0a, 0x0e, 0x04, //	1092	afii10086
0x00, 0x00, 0x00, 0x12, 0x0c, 0x0c, 0x12, 0x00, //	1093	afii10087
0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x1e, 0x02, //	1094	afii10088
0x00, 0x00, 0x00, 0x12, 0x12, 0x0e, 0x02, 0x00, //	1095	afii10089
0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x1f, 0x00, //	1096	afii10090
0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x1f, 0x01, //	1097	afii10091
0x00, 0x00, 0x00, 0x18, 0x0c, 0x0a, 0x0c, 0x00, //	1098	afii10092
0x00, 0x00, 0x00, 0x12, 0x1a, 0x16, 0x1a, 0x00, //	1099	afii10093
0x00, 0x00, 0x00, 0x10, 0x1c, 0x12, 0x1c, 0x00, //	1100	afii10094
0x00, 0x00, 0x00, 0x0c, 0x06, 0x02, 0x0c, 0x00, //	1101	afii10095
0x00, 0x00, 0x00, 0x14, 0x1a, 0x1a, 0x14, 0x00, //	1102	afii10096
0x00, 0x00, 0x00, 0x06, 0x0a, 0x06, 0x0a, 0x00, //	1103	afii10097
0x00, 0x18, 0x16, 0x15, 0x16, 0x14, 0x17, 0x00, //	8470	afii61352
0x00, 0x14, 0x00, 0x0c, 0x16, 0x18, 0x0c, 0x00, //	1105	afii10071
0x00, 0x08, 0x1c, 0x08, 0x0c, 0x0a, 0x02, 0x04, //	1106	afii10099
0x00, 0x04, 0x08, 0x1e, 0x10, 0x10, 0x10, 0x00, //	1107	afii10100
0x00, 0x00, 0x00, 0x06, 0x0c, 0x08, 0x06, 0x00, //	1108	afii10101
0x00, 0x00, 0x00, 0x0e, 0x18, 0x06, 0x1c, 0x00, //	1109	afii10102
0x00, 0x04, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00, //	1110	afii10103
0x00, 0x0a, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00, //	1111	afii10104
0x00, 0x02, 0x00, 0x02, 0x02, 0x02, 0x0a, 0x04, //	1112	afii10105
0x00, 0x00, 0x00, 0x0c, 0x17, 0x15, 0x16, 0x00, //	1113	afii10106
0x00, 0x00, 0x00, 0x14, 0x1e, 0x15, 0x16, 0x00, //	1114	afii10107
0x00, 0x08, 0x1c, 0x08, 0x0c, 0x0a, 0x0a, 0x00, //	1115	afii10108
0x00, 0x04, 0x08, 0x12, 0x1c, 0x14, 0x12, 0x00, //	1116	afii10109
0x0e, 0x10, 0x1c, 0x12, 0x0e, 0x02, 0x1c, 0x00, //	167	section
0x00, 0x12, 0x0c, 0x00, 0x12, 0x0a, 0x04, 0x08, //	1118	afii10110
0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0e, 0x04, //	1119	afii10193
#else
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	160	space
0x00, 0x04, 0x00, 0x04, 0x04, 0x04, 0x04, 0x00, //	161	exclamdown
0x00, 0x00, 0x04, 0x0e, 0x14, 0x14, 0x0e, 0x04, //	162	cent
0x00, 0x04, 0x0a, 0x1c, 0x08, 0x0a, 0x14, 0x00, //	163	sterling
0x00, 0x00, 0x11, 0x0e, 0x0a, 0x0e, 0x11, 0x00, //	164	currency
0x00, 0x11, 0x0a, 0x1f, 0x04, 0x1f, 0x04, 0x00, //	165	yen
0x04, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, //	166	brokenbar
0x0e, 0x10, 0x1c, 0x12, 0x0e, 0x02, 0x1c, 0x00, //	167	section
0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	168	dieresis
0x00, 0x0e, 0x15, 0x19, 0x19, 0x15, 0x0e, 0x00, //	169	copyright
0x06, 0x0a, 0x06, 0x00, 0x0e, 0x00, 0x00, 0x00, //	170	ordfeminine
0x00, 0x00, 0x00, 0x0a, 0x14, 0x0a, 0x00, 0x00, //	171	guillemotleft
0x00, 0x00, 0x00, 0x00, 0x0e, 0x02, 0x02, 0x00, //	172	logicalnot
0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, //	173	hyphen
0x00, 0x0e, 0x1d, 0x1b, 0x1d, 0x1b, 0x0e, 0x00, //	174	registered
0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //	175	macron
0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, //	176	degree
0x00, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x0e, 0x00, //	177	plusminus
0x04, 0x0a, 0x02, 0x04, 0x0e, 0x00, 0x00, 0x00, //	178	twosuperior
0x0c, 0x02, 0x0c, 0x02, 0x0c, 0x00, 0x00, 0x00, //	179	threesuperior
0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, //	180	acute
0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x1c, 0x10, //	181	mu
0x00, 0x0f, 0x1d, 0x1d, 0x0d, 0x05, 0x05, 0x00, //	182	paragraph
0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, //	183	periodcentered
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, //	184	cedilla
0x04, 0x0c, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00, //	185	onesuperior
0x04, 0x0a, 0x04, 0x00, 0x0e, 0x00, 0x00, 0x00, //	186	ordmasculine
0x00, 0x00, 0x00, 0x14, 0x0a, 0x14, 0x00, 0x00, //	187	guillemotright
0x10, 0x10, 0x10, 0x14, 0x0c, 0x1e, 0x04, 0x00, //	188	onequarter
0x10, 0x10, 0x14, 0x1a, 0x02, 0x04, 0x0e, 0x00, //	189	onehalf
0x10, 0x08, 0x10, 0x0c, 0x14, 0x1e, 0x04, 0x00, //	190	threequarters
0x00, 0x04, 0x00, 0x04, 0x08, 0x0a, 0x04, 0x00, //	191	questiondown
0x08, 0x04, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, //	192	Agrave
0x04, 0x08, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, //	193	Aacute
0x0c, 0x12, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, //	194	Acircumflex
0x0a, 0x14, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, //	195	Atilde
0x12, 0x00, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, //	196	Adieresis
0x0c, 0x12, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, //	197	Aring
0x00, 0x0e, 0x14, 0x14, 0x1e, 0x14, 0x16, 0x00, //	198	AE
0x00, 0x0c, 0x12, 0x10, 0x10, 0x12, 0x0c, 0x08, //	199	Ccedilla
0x08, 0x04, 0x1e, 0x10, 0x1c, 0x10, 0x1e, 0x00, //	200	Egrave
0x04, 0x08, 0x1e, 0x10, 0x1c, 0x10, 0x1e, 0x00, //	201	Eacute
0x0c, 0x12, 0x1e, 0x10, 0x1c, 0x10, 0x1e, 0x00, //	202	Ecircumflex
0x12, 0x00, 0x1e, 0x10, 0x1c, 0x10, 0x1e, 0x00, //	203	Edieresis
0x08, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x00, //	204	Igrave
0x02, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x00, //	205	Iacute
0x04, 0x0a, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x00, //	206	Icircumflex
0x0a, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x00, //	207	Idieresis
#ifdef ISO_8859_9
0x12, 0x0c, 0x0e, 0x10, 0x16, 0x12, 0x0c, 0x00, //	286	Gbreve
#else
0x00, 0x0e, 0x09, 0x1d, 0x09, 0x09, 0x0e, 0x00, //	208	Eth
#endif
0x0a, 0x14, 0x12, 0x1a, 0x16, 0x12, 0x12, 0x00, //	209	Ntilde
0x08, 0x04, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, //	210	Ograve
0x04, 0x08, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, //	211	Oacute
0x0c, 0x12, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, //	212	Ocircumflex
0x0a, 0x14, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, //	213	Otilde
0x12, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, //	214	Odieresis
0x00, 0x00, 0x00, 0x00, 0x0a, 0x04, 0x0a, 0x00, //	215	multiply
0x00, 0x0e, 0x16, 0x16, 0x1a, 0x1a, 0x1c, 0x00, //	216	Oslash
0x08, 0x04, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, //	217	Ugrave
0x04, 0x08, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, //	218	Uacute
0x0c, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, //	219	Ucircumflex
0x12, 0x00, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, //	220	Udieresis
#ifdef ISO_8859_9
0x04, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x00, //	304	Idotaccent
0x00, 0x0c, 0x12, 0x08, 0x04, 0x12, 0x0c, 0x04, //	350	Scedilla
#else
0x02, 0x04, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, //	221	Yacute
0x00, 0x10, 0x1c, 0x12, 0x12, 0x1c, 0x10, 0x00, //	222	Thorn
#endif
0x00, 0x0c, 0x12, 0x14, 0x14, 0x12, 0x14, 0x00, //	223	germandbls
0x08, 0x04, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	224	agrave
0x04, 0x08, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	225	aacute
0x04, 0x0a, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	226	acircumflex
0x0a, 0x14, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	227	atilde
0x00, 0x0a, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	228	adieresis
0x0c, 0x12, 0x0c, 0x0e, 0x12, 0x12, 0x0e, 0x00, //	229	aring
0x00, 0x00, 0x00, 0x1e, 0x0d, 0x16, 0x0f, 0x00, //	230	ae
0x00, 0x00, 0x00, 0x06, 0x08, 0x08, 0x06, 0x04, //	231	ccedilla
0x08, 0x04, 0x00, 0x0c, 0x16, 0x18, 0x0c, 0x00, //	232	egrave
0x04, 0x08, 0x00, 0x0c, 0x16, 0x18, 0x0c, 0x00, //	233	eacute
0x0c, 0x12, 0x00, 0x0c, 0x16, 0x18, 0x0c, 0x00, //	234	ecircumflex
0x00, 0x0a, 0x00, 0x0c, 0x16, 0x18, 0x0c, 0x00, //	235	edieresis
0x08, 0x04, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00, //	236	igrave
0x02, 0x04, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00, //	237	iacute
0x04, 0x0a, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00, //	238	icircumflex
0x00, 0x0a, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00, //	239	idieresis
#ifdef ISO_8859_9
0x12, 0x0c, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x0c, //	287	gbreve
#else
0x14, 0x08, 0x14, 0x02, 0x0e, 0x12, 0x0c, 0x00, //	240	eth
#endif
0x0a, 0x14, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x00, //	241	ntilde
0x08, 0x04, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, //	242	ograve
0x04, 0x08, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, //	243	oacute
0x0c, 0x12, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, //	244	ocircumflex
0x0a, 0x14, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, //	245	otilde
0x00, 0x12, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, //	246	odieresis
0x00, 0x00, 0x04, 0x00, 0x0e, 0x00, 0x04, 0x00, //	247	divide
0x00, 0x00, 0x00, 0x0e, 0x16, 0x1a, 0x1c, 0x00, //	248	oslash
0x08, 0x04, 0x00, 0x12, 0x12, 0x12, 0x0e, 0x00, //	249	ugrave
0x04, 0x08, 0x00, 0x12, 0x12, 0x12, 0x0e, 0x00, //	250	uacute
0x0c, 0x12, 0x00, 0x12, 0x12, 0x12, 0x0e, 0x00, //	251	ucircumflex
0x00, 0x12, 0x00, 0x12, 0x12, 0x12, 0x0e, 0x00, //	252	udieresis
#ifdef ISO_8859_9
0x00, 0x00, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00, //	305	dotlessi
0x00, 0x00, 0x00, 0x06, 0x0c, 0x02, 0x0c, 0x04, //	351	scedilla
#else
0x04, 0x08, 0x00, 0x12, 0x12, 0x0e, 0x12, 0x0c, //	253	yacute
0x00, 0x10, 0x10, 0x1c, 0x12, 0x1c, 0x10, 0x10, //	254	thorn
#endif	// ISO_8859_9
0x00, 0x12, 0x00, 0x12, 0x12, 0x0e, 0x12, 0x0c, //	255	ydieresis
#endif
#endif	// DISPLAY_DOT
};

void EmptyFontFunction()
{
}
