/*-------------------------------------------------------------------------
   AR1688 DSP none-API bank1 function copy right information

   Copyright (c) 2015.      Lin, Rongrong <woody@palmmicro.com>

   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Palmmicro nor the names of its contributors may be
	  used to endorse or promote products derived from this software without
	  specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
   DISCLAIMED. IN NO EVENT SHALL COPYRIGHT OWNER BE LIABLE FOR ANY
   DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
   LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
-------------------------------------------------------------------------*/

#include "version.h"
#include "type.h"
#include "core.h"
#include "apps.h"
#include "tcpip.h"
//#include "bank1.h"


//#ifndef CALL_NONE
void DspMiniRun(UCHAR iFrames1, PCHAR pBuf1, UCHAR iFrames2, PCHAR pBuf2, UCHAR iMaxCodecLen)
{
#ifdef SYS_MINI_RUN
	PCHAR pBackup;
	USHORT sBackupLen;

	sBackupLen = mul_8x8(iFrames1 + iFrames2, iMaxCodecLen);
	sBackupLen += UDP_EXTRA + 13;	// extra 12 bytes for RTP head, 1 byte for checksum
	pBackup = malloc(sBackupLen);
	if (!pBackup)	return;	// fail silently
	memcpy(pBackup, Adapter_pPacketBuf, sBackupLen);
	TaskOutgoingData(iFrames1, pBuf1, iFrames2, pBuf2);
	memcpy(Adapter_pPacketBuf, pBackup, sBackupLen);
	free(pBackup);
	//			UdpDebugString("Mini send");
#else
	iFrames1;
	pBuf1;
	iFrames2;
	pBuf2;
	iMaxCodecLen;
#endif
}
//#endif

